
package cn.smarthse.radiationTraining.modules.sys.entity.sys;

import lombok.Data;

import javax.persistence.*;
import java.io.Serializable;

/**
 * 
 * 四级行业
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年9月27日 上午10:24:59
 */
@Table(name = "sys_industry")
public @Data class SysIndustry implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * id
	 */
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select uuid_short()")
	private Long id;
	/**
	 * 父id
	 */
	private Long pid;
	/**
	 * 行业编码
	 */
	private String code;
	/**
	 * 父行业编码
	 */
	private String pcode;
	/**
	 * 名称
	 */
	private String name;
	/**
	 * 行业级别从1开始
	 */
	private Integer level;
	/**
	 * 是否是叶子节点(0:不是; 1:是)
	 */
	private Integer isLeaf;
	/**
	 * 一级行业编码
	 */
	private String industryCode1;
	/**
	 * 二级行业编码
	 */
	private String industryCode2;
	/**
	 * 三级行业编码
	 */
	private String industryCode3;
	/**
	 * 四级行业编码
	 */
	private String industryCode4;
	/**
	 * 一级行业
	 */
	private String industryName1;
	/**
	 * 二级行业
	 */
	private String industryName2;
	/**
	 * 三级行业
	 */
	private String industryName3;
	/**
	 * 四级行业
	 */
	private String industryName4;
	/**
	 * 描述
	 */
	private String description;
	/**
	 * 危害程度(严重 -WHCDS  一般-WHCDC 未划分-WHF 未细分-WXF)
	 */
	private String harmLevel;
	/**
	 * 行业类型标记（0: 默认, 无实际含义; 1: 重点行业1-冶金; 2-矿山; 3-化工; 4-建材; 5,6,7...可拓展）
	 */
	private Integer industryType;
	/**
	 * 是否显示
	 */
	private Boolean isShow;
	/**
	 * 同节点下行业排序(默认为id值)
	 */
	private Long sort;
	/**
	 * 查询热度
	 */
	private Long hot;
	/**
	 * 创建人
	 */
	private Long createBy;
	/**
	 * 创建时间
	 */
	private java.util.Date createDate;
	/**
	 * 最后修改人ID
	 */
	private Long updateBy;
	/**
	 * 最后修改时间
	 */
	private java.util.Date updateDate;
	/**
	 * 是否有效
	 */
	private Boolean isValid;

}
