package cn.smarthse.radiationTraining.modules.sys.entity.order;

import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.util.Date;

/**
 * 订单操作记录
 *
 * @author wuxq
 * @since 2025年5月19日 下午1:34:15
 */
@NoArgsConstructor
@EqualsAndHashCode(callSuper = true)
@TableName(value = "sys_order_log")
public @Data class SysOrderLog extends BaseBean {

    private static final long serialVersionUID = 1L;

    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 订单id
     */
    private Long orderId;

    /**
     * 订单操作记录类型(1-缴费成功; 2-申请退款；3-退款成功；4-退款失败)
     */
    private Integer type;

    /**
     * 订单操作记录类型(1-缴费成功; 2-申请退款；3-退款成功；4-退款失败)
     */
    private String typeStr;

    /**
     * 操作人id
     */
    private Long operatorId;

    /**
     * 操作人
     */
    private String operator;

    /**
     * 操作时间
     */
    private Date operateDate;

    /**
     * 备注
     */
    private String remark;

    public SysOrderLog(Long orderId, Integer type, String typeStr, Long operatorId, String operator, Date operateDate, String remark) {
        this.orderId = orderId;
        this.type = type;
        this.typeStr = typeStr;
        this.operatorId = operatorId;
        this.operator = operator;
        this.operateDate = operateDate;
        this.remark = remark;
    }
}
