
package cn.smarthse.radiationTraining.modules.sys.entity.admin;

import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Table;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 
 *  后台-用户信息
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/4年14:16月日
 */
@EqualsAndHashCode(callSuper = true)
@Table(name = "admin")
public @Data class Admin extends BaseBean {

	private static final long serialVersionUID = 1L;
	/**
	 * 用户id
	 */
	@TableId(value = "id", type = IdType.ASSIGN_ID)
	private Long id;
	/**
	 * 手机号
	 */
	private String username;
	/**
	 * 盐值
	 */
	private String salt;
	/**
	 * 密码
	 */
	private String password;
	/**
	 * 手机号
	 */
	private String mobile;
	/**
	 * 邮箱
	 */
	private String email;
	/**
	 * 头像
	 */
	private String avatar;
	/**
	 * 用户名
	 */
	private String name;
	/**
	 * 性别0男1女
	 */
	private Integer sex;
	/**
	 * 出生日期
	 */
	private LocalDate birth;
	/**
	 * 行政区划（用于匹配业务数据）
	 */
	private Long areaId;
	/**
	 * 单位（监管用户角色有）
	 */
	private String org;
	/**
	 * 令牌Token（单点登录使用）
	 */
	private String token;
	/**
	 * 是否禁用（1-禁用；0-启用）
	 */
	private Integer isForbidden;

	/**
	 * 运维用户角色（0：管理员  1 ：中级  3： 基础）
	 */
	private Integer operationRole;

	/**
	 * 用户来源（0监管；1浙政厅；2运维端)
	 */
	private Integer userFrom;



	/**
	 * 区域等级(0-国家,1-省,2-市,3-区、县,4-乡、镇、街道,5-村、居委会)
	 */
	@TableField(exist = false)
	private Integer level;
}
