package cn.smarthse.radiationTraining.modules.sys.entity;

import cn.smarthse.radiationTraining.core.framework.model.BaseBean;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Getter;
import lombok.Setter;
import lombok.experimental.Accessors;

/**
 * <p>
 * 
 * </p>
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @since 2022-02-15
 */
@Getter
@Setter
@Accessors(chain = true)
@TableName("sys_area")
public class SysArea extends BaseBean {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    @TableField("pid")
    private Long pid;

    /**
     * 简称
     */
    @TableField("short_name")
    private String shortName;

    /**
     * 名称
     */
    @TableField("name")
    private String name;

    /**
     * 简拼
     */
    @TableField("py")
    private String py;

    /**
     * 全拼
     */
    @TableField("py_full")
    private String pyFull;

    /**
     * 经度
     */
    @TableField("lng")
    private String lng;

    /**
     * 纬度
     */
    @TableField("lat")
    private String lat;

    /**
     * 级别(0-国家,1-省,2-市,3-区、县,4-乡、镇、街道,5-村、居委会)
     */
    @TableField("level")
    private Integer level;

    /**
     * 同一级的区域排序字段(默认为id值)
     */
    @TableField("sort")
    private Long sort;

    /**
     * 省编号
     */
    @TableField("province_id")
    private Long provinceId;

    /**
     * 省名称
     */
    @TableField("province_name")
    private String provinceName;

    /**
     * 市编号
     */
    @TableField("city_id")
    private Long cityId;

    /**
     * 市名称
     */
    @TableField("city_name")
    private String cityName;

    /**
     * 区域ID
     */
    @TableField("area_id")
    private Long areaId;

    /**
     * 区域名称
     */
    @TableField("area_name")
    private String areaName;

    /**
     * 乡镇街道编号
     */
    @TableField("street_id")
    private Long streetId;

    /**
     * 乡镇街道名称
     */
    @TableField("street_name")
    private String streetName;
}
