package cn.smarthse.radiationTraining.modules.sys.dto.sys;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.List;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 行政区划树形结构dto
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/16 9:01
 */
@Accessors(chain = true)
@Data
public class SysAreaTreeDto implements Serializable {

    private static final long serialVersionUID = -6691778572026110561L;

    @ApiModelProperty(value = "行政区划id")
    private Long id;

    @ApiModelProperty(value = "行政区划名")
    private String name;

    @ApiModelProperty(value = "是否是父级节点")
    private Boolean isParent;

    @ApiModelProperty(value = "父级id")
    private Long parentId;

    @ApiModelProperty(value = "行政区划等级")
    private Integer areaLevel;

    @ApiModelProperty(value = "是否展开")
    private Boolean open = true;

    @ApiModelProperty(value = "子树")
    List<SysAreaTreeDto> children;

    public SysAreaTreeDto() {

    }

    public SysAreaTreeDto(Long id, String name, Boolean isParent, Long parentId, Integer areaLevel) {
        super();
        this.id = id;
        this.name = name;
        this.isParent = isParent;
        this.parentId = parentId;
        this.areaLevel = areaLevel;
    }
}
