package cn.smarthse.radiationTraining.modules.sys.dto.sys;

import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import lombok.Data;
import lombok.experimental.Accessors;

/**
 * 行政区划id和 行政区划名(eg：浙江省>杭州市>上城区>笕桥街道)对应关系
 * 用于校准行政区划id
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/3/21 17:30
 */
@Accessors(chain = true)
@Data
public class AreaAddress implements Serializable {

    private static final long serialVersionUID = -6691778572026110561L;

    @ApiModelProperty(value = "行政区划id")
    private Long id;

    @ApiModelProperty(value = "行政区划名 eg：浙江省>杭州市>上城区>笕桥街道")
    private String areaAddress;
}
