package cn.smarthse.radiationTraining.modules.sys.dto.order;

import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrder;
import cn.smarthse.radiationTraining.modules.sys.entity.order.SysOrderRefund;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 订单退款上下文
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/4/19 13:57
 */
@Data
public class OrderRefundContext implements Serializable {

    @ApiModelProperty("订单")
    SysOrder order;

    @ApiModelProperty("本次订单退款记录")
    SysOrderRefund orderRefund;

    @ApiModelProperty("订单所有退款记录")
    List<SysOrderRefund> orderRefundList;

    /**
     * 获取订单id
     */
    public Long getOrderId() {
        return this.getOrder().getId();
    }

    /**
     * 获取userId
     */
    public Long getUserId() {
        return this.getOrder().getUserId();
    }
}
