package cn.smarthse.radiationTraining.modules.sys.dto;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * 行政区划-详细信息dto
 *
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2022/2/16 21:06
 */
@Data
public class AreaDetailDto implements Serializable {

	private static final long serialVersionUID = 4315866872516136916L;

	@ApiModelProperty("行政区划id")
	private Long id;

	@ApiModelProperty("行政区划pid")
	private Long pid;

	@ApiModelProperty("行政区划简称")
	private String shortName;

	@ApiModelProperty("名称")
	private String name;

	@ApiModelProperty("简拼")
	private String py;

	@ApiModelProperty("全拼")
	private String pyFull;

	@ApiModelProperty("经度")
	private String lng;

	@ApiModelProperty("纬度")
	private String lat;

	@ApiModelProperty("级别(0-国家,1-省,2-市,3-区、县,4-乡、镇、街道,5-村、居委会)")
	private Integer level;

	@ApiModelProperty("省编号")
	private Long provinceId;

	@ApiModelProperty("省名称")
	private String provinceName;

	@ApiModelProperty("市编号")
	private Long cityId;

	@ApiModelProperty("市名称")
	private String cityName;

	@ApiModelProperty("区域ID")
	private Long areaId;

	@ApiModelProperty("区域名称")
	private String areaName;

	@ApiModelProperty("乡镇街道编号")
	private Long streetId;

	@ApiModelProperty("乡镇街道名称")
	private String streetName;
}
