package cn.smarthse.radiationTraining.modules.sys.converter.web;

import cn.smarthse.radiationTraining.modules.sys.entity.web.Article;
import cn.smarthse.radiationTraining.modules.sys.param.web.article.SaveArticleParam;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleApiVo;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleTurnPage;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleVo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Generated;
import org.springframework.stereotype.Component;

@Generated(
    value = "org.mapstruct.ap.MappingProcessor",
    date = "2025-07-04T08:54:30+0800",
    comments = "version: 1.5.5.Final, compiler: javac, environment: Java 1.8.0_131 (Oracle Corporation)"
)
@Component
public class ArticleConverterImpl implements ArticleConverter {

    @Override
    public ArticleVo article2ArticleVo(Article article) {
        if ( article == null ) {
            return null;
        }

        ArticleVo articleVo = new ArticleVo();

        articleVo.setId( article.getId() );
        articleVo.setTitle( article.getTitle() );
        articleVo.setSummary( article.getSummary() );
        articleVo.setContent( article.getContent() );
        articleVo.setType( article.getType() );
        articleVo.setImageUrl( article.getImageUrl() );
        articleVo.setIsTop( article.getIsTop() );
        articleVo.setClicks( article.getClicks() );
        articleVo.setState( article.getState() );
        articleVo.setResource( article.getResource() );
        if ( article.getReleaseDate() != null ) {
            articleVo.setReleaseDate( new SimpleDateFormat().format( article.getReleaseDate() ) );
        }
        articleVo.setReleaser( article.getReleaser() );

        return articleVo;
    }

    @Override
    public List<ArticleVo> article2ArticleVoList(List<Article> articleList) {
        if ( articleList == null ) {
            return null;
        }

        List<ArticleVo> list = new ArrayList<ArticleVo>( articleList.size() );
        for ( Article article : articleList ) {
            list.add( article2ArticleVo( article ) );
        }

        return list;
    }

    @Override
    public Article saveArticleParam2Article(SaveArticleParam param) {
        if ( param == null ) {
            return null;
        }

        Article article = new Article();

        article.setId( param.getId() );
        article.setTitle( param.getTitle() );
        article.setType( param.getType() );
        article.setSummary( param.getSummary() );
        article.setContent( param.getContent() );
        article.setImageUrl( param.getImageUrl() );
        article.setFiles( param.getFiles() );
        article.setState( param.getState() );
        article.setResource( param.getResource() );
        article.setReleaseBy( param.getReleaseBy() );
        article.setReleaser( param.getReleaser() );

        return article;
    }

    @Override
    public ArticleApiVo article2ArticleApiVo(Article article) {
        if ( article == null ) {
            return null;
        }

        ArticleApiVo articleApiVo = new ArticleApiVo();

        articleApiVo.setId( article.getId() );
        articleApiVo.setTitle( article.getTitle() );
        articleApiVo.setSummary( article.getSummary() );
        articleApiVo.setContent( article.getContent() );
        articleApiVo.setType( article.getType() );
        articleApiVo.setImageUrl( article.getImageUrl() );
        articleApiVo.setIsTop( article.getIsTop() );
        articleApiVo.setClicks( article.getClicks() );
        articleApiVo.setState( article.getState() );
        articleApiVo.setResource( article.getResource() );
        if ( article.getReleaseDate() != null ) {
            articleApiVo.setReleaseDate( new SimpleDateFormat().format( article.getReleaseDate() ) );
        }
        articleApiVo.setReleaser( article.getReleaser() );

        return articleApiVo;
    }

    @Override
    public ArticleTurnPage article2ArticleTurnPage(Article article) {
        if ( article == null ) {
            return null;
        }

        ArticleTurnPage articleTurnPage = new ArticleTurnPage();

        articleTurnPage.setId( article.getId() );
        articleTurnPage.setTitle( article.getTitle() );

        return articleTurnPage;
    }
}
