package cn.smarthse.radiationTraining.modules.sys.converter.web;

import cn.smarthse.radiationTraining.modules.sys.entity.web.Article;
import cn.smarthse.radiationTraining.modules.sys.param.web.article.SaveArticleParam;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleApiVo;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleTurnPage;
import cn.smarthse.radiationTraining.modules.sys.vo.web.vo.ArticleVo;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

/**
 *
 *  article 对象转换器
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/2/24年13:44月日
 */
@Mapper(componentModel = "spring")
public interface ArticleConverter {

    ArticleConverter INSTANCE = Mappers.getMapper(ArticleConverter.class);

    /**
     * Article to ArticleVo
     * @author liaoly
     * @date 2022/2/24 13:43
     * @param article Article
     * @return {@link ArticleVo}
     */
    @Mapping(target = "files", ignore = true)
    ArticleVo article2ArticleVo(Article article);

    /**
     * List<Article> to List<ArticleVo>
     * @author liaoly
     * @date 2022/3/14 15:50
     * @param articleList Article集合
     * @return {@link List<ArticleVo>}
     */
    List<ArticleVo> article2ArticleVoList (List<Article> articleList);

    /**
     * SaveArticleParam to Article
     * @author liaoly
     * @date 2022/3/14 15:49
     * @param param SaveArticleParam
     * @return {@link Article}
     */
    Article saveArticleParam2Article(SaveArticleParam param);

    /**
     * Article to ArticleApiVo
     * @author liaoly
     * @date 2022/2/24 13:43
     * @param article Article
     * @return {@link ArticleApiVo}
     */
    @Mapping(target = "files", ignore = true)
    ArticleApiVo article2ArticleApiVo(Article article);

    /**
     * Article to ArticleTurnPage
     * @author liaoly
     * @date 2022/2/24 13:43
     * @param article Article
     * @return {@link ArticleApiVo}
     */
    ArticleTurnPage article2ArticleTurnPage(Article article);
}