package cn.smarthse.radiationTraining.modules.sys.converter.user;

import cn.smarthse.radiationTraining.modules.sys.dto.user.UserToAdminDto;
import cn.smarthse.radiationTraining.modules.sys.entity.user.SysUser;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompany;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.CompanyModifyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserCropVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.UserVo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

/**
 *
 *  user对象转换器
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/2/24年13:44月日
 */
@Mapper(componentModel = "spring")
public interface UserConverter {

    UserConverter INSTANCE = Mappers.getMapper(UserConverter.class);

    /**
     * SysUser to UserVo
     * @author liaoly
     * @date 2022/2/24 13:43
     * @param user SysUser
     * @return {@link UserToAdminDto}
     */
    UserVo user2UserVo(SysUser user);

    /**
     * SysUser to UserCropVo
     * @param user SysUser
     * @return {@link UserCropVo}
     * @author liaoly
     * @date 2022/3/15 14:19
     */
    UserCropVo user2UserCropVo(SysUser user);

    /**
     * 同步修改信息vo to 账号实体
     */
    @Mapping(source = "uid", target = "id")
    SysUser modifyVoToEntity(CompanyModifyVo vo);

    /**
     * 同步修改信息vo to 单位实体
     */
    @Mapping(source = "uid", target = "userId")
    SysCompany modifyVoToCompany(CompanyModifyVo vo);
}