package cn.smarthse.radiationTraining.modules.sys.converter.user;

import cn.smarthse.radiationTraining.modules.sys.dto.user.UserToAdminDto;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompany;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysUserInfo;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.shiro.UserInfo;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

/**
 *
 *  syUserInfo 对象转换器
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/2/24年13:44月日
 */
@Mapper(componentModel = "spring")
public interface SysUserInfoConverter {

    SysUserInfoConverter INSTANCE = Mappers.getMapper(SysUserInfoConverter.class);

    /**
     * SysUserInfo to UserInfo
     * @author liaoly
     * @date 2022/2/24 13:43
     * @param sysUserInfo SysUserInfo
     * @return {@link UserInfo}
     */
    @Mapping(target = "sex", expression = "java(cn.smarthse.radiationTraining.modules.sys.enums.SexEnum.getName(sysUserInfo.getSex()))")
    UserInfo sysUserInfo2UserInfo(SysUserInfo sysUserInfo);

    List<UserInfo> sysUserInfo2UserInfo (List<SysUserInfo> sysUserInfoList);
}