package cn.smarthse.radiationTraining.modules.sys.converter.user;

import cn.smarthse.radiationTraining.modules.sys.dto.user.UserToAdminDto;
import cn.smarthse.radiationTraining.modules.sys.dto.user.info.ImportCompanyData;
import cn.smarthse.radiationTraining.modules.sys.entity.user.info.SysCompany;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyVo;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 *
 *  company 对象转换器
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/2/24年13:44月日
 */
@Mapper(componentModel = "spring")
public interface CompanyConverter {

    CompanyConverter INSTANCE = Mappers.getMapper(CompanyConverter.class);

    /**
     * SysCompany to CompanyInfo
     * @author liaoly
     * @date 2022/2/24 13:43
     * @param company -
     * @return {@link UserToAdminDto}
     */
    CompanyInfo company2ConpanyInfo(SysCompany company);

    List<CompanyInfo> company2ConpanyInfoList(List<SysCompany> companyList);

    /**
     * SysCompany to CompanyVo
     * @param company -
     * @return {@link CompanyVo}
     * @author liaoly
     * @date 2022/3/17 11:27
     */
    CompanyVo company2CompanyVo(SysCompany company);

    /**
     * List<ImportCompanyData> to List<SysCompany>
     * @param list
     * @return {@link List<SysCompany>}
     * @author liaoly
     * @date 2022/3/17 15:23
     */
    List<SysCompany> importCompanyData2Company(List<ImportCompanyData> list);
}