package cn.smarthse.radiationTraining.modules.sys.converter.sys;

import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysFeedback;
import cn.smarthse.radiationTraining.modules.sys.enums.sys.FeedbackTypeEnum;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveFeedbackParam;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

/**
 * @ClassName SysFeedbackConverter
 * @Description SysFeedback对象转换器
 * @Author ChenLiang
 * @ModifyDate 2022/3/23 9:44
 */
@Mapper(componentModel = "spring", imports = {FeedbackTypeEnum.class})
public interface SysFeedbackConverter {
    SysFeedbackConverter INSTANCE = Mappers.getMapper(SysFeedbackConverter.class);
    @Mapping(target = "content",expression = "java(Util.dealContent(saveFeedbackParam))")
    SysFeedback saveParam2Entity(SaveFeedbackParam saveFeedbackParam);


    class Util{
        static String dealContent(SaveFeedbackParam saveFeedbackParam){
            String template = FeedbackTypeEnum.getContent(saveFeedbackParam.getType());
            String content = saveFeedbackParam.getContent();
            return template.replaceAll("%s",content);
        }
    }
}
