package cn.smarthse.radiationTraining.modules.sys.converter.sys;

import cn.smarthse.radiationTraining.modules.sys.entity.sys.SysFile;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileModel;
import cn.smarthse.radiationTraining.modules.sys.vo.sys.SysFileVo;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.factory.Mappers;

/**
 *
 *  SysFile 对象转换器
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/2/24年13:44月日
 */
@Mapper(componentModel = "spring")
public interface FileConverter {

    FileConverter INSTANCE = Mappers.getMapper(FileConverter.class);

    /**
     * SysFile to SysFileModel
     * @author liaoly
     * @date 2022/3/9 17:40
     * @param file SysFile
     * @return {@link SysFileModel}
     */
    SysFileModel file2FileModel(SysFile file);

    /**
     * SysFileModel to SysFile
     * @author liaoly
     * @date 2022/3/9 17:40
     * @param fileModel SysFileModel
     * @return {@link SysFile}
     */
    SysFile fileModel2File(SysFileModel fileModel);

    /**
     * SysFile to FileVo
     * @param list -
     * @return {@link List<SysFileVo>}
     * @author liaoly
     * @date 2022/3/18 9:39
     */
    List<SysFileVo> file2FileVo(List<SysFile> list);
}