package cn.smarthse.radiationTraining.modules.sys.converter.hse;

import cn.smarthse.radiationTraining.modules.sys.entity.hse.HseCompany;
import cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo;
import cn.smarthse.radiationTraining.modules.sys.vo.hse.HseCompanyVo;
import cn.smarthse.radiationTraining.modules.sys.vo.user.info.CompanyVo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

@Mapper(componentModel = "spring")
public interface HseCompanyConverter {
    HseCompanyConverter INSTANCE = Mappers.getMapper(HseCompanyConverter.class);

    /**
     * @description 返回培训老的结构
     * @param hseCompany
     * @return cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo
     * @author chenliang
     * @date 2022/10/26 11:00:43
     */
    @Mapping(source = "hseCompany.id", target = "id")
    @Mapping(source = "hseCompany.name", target = "name")
    @Mapping(source = "hseCompany.unifiedSocialCc", target = "creditCode")
    @Mapping(source = "hseCompany.occManagerName", target = "contact")
    @Mapping(source = "hseCompany.companyContactTel", target = "contactTel")
    @Mapping(source = "hseCompany.areaId", target = "areaId")
    @Mapping(source = "hseCompany.registerAddress", target = "areaAddress")
    @Mapping(source = "hseCompany.registerAddress", target = "address")
    @Mapping(source = "hseCompany.industryCategory", target = "industryCode")
    @Mapping(source = "hseCompany.belongType", target = "belongType")
    CompanyInfo vo2ConpanyInfo(HseCompanyVo hseCompany);

//    /**
//     * @description 返回培训老的结构
//     * @param hseCompany
//     * @return cn.smarthse.radiationTraining.modules.sys.shiro.CompanyInfo
//     * @author chenliang
//     * @date 2022/10/26 11:00:26
//     */
//    @Mapping(source = "hseCompany.id", target = "id")
//    @Mapping(source = "hseCompany.name", target = "name")
//    @Mapping(source = "hseCompany.unifiedSocialCc", target = "creditCode")
//    @Mapping(source = "hseCompany.areaId", target = "areaId")
//    @Mapping(source = "hseCompany.registerAddress", target = "address")
//    CompanyVo vo2OldVo(HseCompanyVo hseCompany);




    HseCompanyVo entity2Vo(HseCompany hseCompany);

}
