package cn.smarthse.radiationTraining.modules.sys.converter;

import cn.smarthse.radiationTraining.modules.sys.dto.AreaDto;
import cn.smarthse.radiationTraining.modules.sys.entity.SysArea;
import java.util.List;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

/**
 *
 *  area to Dto
 *
 * @author liaoly(廖凌云) [1302013247@qq.com]
 * @date 2022/2/24年13:44月日
 */
@Mapper(componentModel = "spring")
public interface AreaDtoMap {

    AreaDtoMap INSTANCE = Mappers.getMapper(AreaDtoMap.class);

    /**
     * SysArea to AreaDto
     * @author liaoly
     * @date 2022/2/24 13:43
     * @param area SysArea
     * @return {@link AreaDto}
     */
    @Mapping(target = "name", source = "name")
    AreaDto area2areaDto(SysArea area);

    /**
     * List<SysArea> to List<AreaDto>
     * @author liaoly
     * @date 2022/2/24 13:43
     * @param areaList SysArea集合
     * @return {@link AreaDto}
     */
    List<AreaDto> area2areaDto(List<SysArea> areaList);
}