/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.question.service.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.smarthse.radiationTraining.core.framework.Constant;
import cn.smarthse.radiationTraining.core.framework.RedisKey;
import cn.smarthse.radiationTraining.core.framework.bean.RedisUtil;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.core.framework.utils.DateUtils;
import cn.smarthse.radiationTraining.modules.question.converter.QuestionConverter;
import cn.smarthse.radiationTraining.modules.question.converter.TuPaperQuestionConverter;
import cn.smarthse.radiationTraining.modules.question.dao.TuPaperMapper;
import cn.smarthse.radiationTraining.modules.question.entity.PaperStructure;
import cn.smarthse.radiationTraining.modules.question.entity.Question;
import cn.smarthse.radiationTraining.modules.question.entity.TuPaper;
import cn.smarthse.radiationTraining.modules.question.entity.TuPaperQuestion;
import cn.smarthse.radiationTraining.modules.question.enums.AnswerJudgeResultEnum;
import cn.smarthse.radiationTraining.modules.question.enums.ExamResultEnum;
import cn.smarthse.radiationTraining.modules.question.enums.PaperReTestSettingEnum;
import cn.smarthse.radiationTraining.modules.question.enums.PaperUsageEnum;
import cn.smarthse.radiationTraining.modules.question.enums.QuestionTypeEnum;
import cn.smarthse.radiationTraining.modules.question.param.ExamRecordsSearchParam;
import cn.smarthse.radiationTraining.modules.question.param.StartExamParam;
import cn.smarthse.radiationTraining.modules.question.param.SubmitExamParam;
import cn.smarthse.radiationTraining.modules.question.service.IPaperStructureService;
import cn.smarthse.radiationTraining.modules.question.service.IQuestionService;
import cn.smarthse.radiationTraining.modules.question.service.ITuPaperQuestionService;
import cn.smarthse.radiationTraining.modules.question.service.ITuPaperService;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperDataVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperResultVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamQuestionsDataVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamRecordVo;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class TuPaperServiceImpl
extends ServiceImpl<TuPaperMapper, TuPaper>
implements ITuPaperService {
    @Autowired
    private RedisUtil redisUtil;
    @Autowired(required=false)
    private QuestionConverter questionConverter;
    @Autowired(required=false)
    private TuPaperQuestionConverter tuPaperQuestionConverter;
    @Autowired
    private IQuestionService questionService;
    @Autowired
    private ITuPaperQuestionService paperQuestionService;
    @Autowired
    private IPaperStructureService paperStructureService;

    @Override
    public String getExamProgressByTrainingId(Long trainingId) {
        if (trainingId == null) {
            throw new ServiceException("\u5fc5\u8981\u53c2\u6570\u7f3a\u5931\uff01");
        }
        return ((TuPaperMapper)this.baseMapper).getExamProgressByTrainingId(trainingId);
    }

    @Override
    public LayuiGridData<ExamRecordVo> getExamRecords(ExamRecordsSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<ExamRecordVo> list = ((TuPaperMapper)this.baseMapper).getExamRecordsList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public ExamPaperResultVo getCourseExamDetail(Long id) {
        ExamPaperResultVo resultVo = ((TuPaperMapper)this.baseMapper).getExamPaperResultVoById(id);
        if (resultVo == null) {
            throw new ServiceException("\u8bd5\u5377\u4e0d\u5b58\u5728\uff01");
        }
        List paperQuestions = this.paperQuestionService.list((Wrapper)Wrappers.query().lambda().eq(TuPaperQuestion::getTuPaperId, (Object)id));
        return resultVo.setQuestions(paperQuestions);
    }

    @Override
    @Transactional(readOnly=false)
    public ExamPaperDataVo getExamQuestions(StartExamParam param) {
        List<Object> paperQuestionList = new ArrayList();
        TuPaper paper = this.initTuPaperForGetExamQuestions(param);
        if (paper != null && !paper.getIsNewPaper().booleanValue()) {
            paperQuestionList = this.paperQuestionService.getByPaperId(paper.getId());
        } else {
            List riskFactors = param.getRiskFactorCodes().stream().distinct().collect(Collectors.toList());
            param.setRiskFactorCodes(riskFactors);
            if (param.getTestPaperUsage().equals(PaperUsageEnum.LEARNER_COMMON.getValue())) {
                paperQuestionList = this.getEarliestPaperQuestion(param.getTid(), param.getCourseId(), param.getTestMode());
            }
            if (CollUtil.isEmpty(paperQuestionList)) {
                paperQuestionList = this.getQuestionsByFactorsAndPaperStructure(param);
            }
        }
        if (CollUtil.isEmpty(paperQuestionList)) {
            throw new ServiceException("\u672a\u8c03\u53d6\u5230\u76f8\u5339\u914d\u7684\u8bd5\u9898\uff01");
        }
        for (TuPaperQuestion tuPaperQuestion : paperQuestionList) {
            tuPaperQuestion.setTuPaperId(paper.getId());
            tuPaperQuestion.setUserId(param.getUserId());
        }
        if (paper.getIsNewPaper().booleanValue()) {
            paperQuestionList.forEach(item -> {
                item.setId(null);
                item.setCreateTime(new Date());
                item.setUpdateTime(new Date());
            });
            this.paperQuestionService.saveBatch(paperQuestionList);
        }
        List examQuestionList = this.tuPaperQuestionConverter.toExamQuestionsDataVoList(paperQuestionList);
        examQuestionList.forEach(item -> item.setAnswerLength(Integer.valueOf(item.getAnswer() == null ? 0 : item.getAnswer().length())));
        this.redisUtil.addHashCache((Object)"TUPAPER", (Object)RedisKey.getTuPaper((Long)paper.getId()), (Object)JSON.toJSONString((Object)paper), 1L, TimeUnit.DAYS);
        this.redisUtil.addHashCache((Object)"TUPAPERQUESTION", (Object)RedisKey.getTuPaperQuestion((Long)paper.getId()), (Object)JSON.toJSONString(paperQuestionList), 1L, TimeUnit.DAYS);
        return new ExamPaperDataVo().setTid(param.getTid()).setEnrollDetailId(param.getEnrollDetailId()).setTuCourseId(param.getTuCourseId()).setPaperStructureId(param.getPaperStructureId()).setTuPaperId(paper.getId()).setQuestions(examQuestionList);
    }

    public TuPaper initTuPaperForGetExamQuestions(StartExamParam param) {
        TuPaper unansweredPaper;
        TuPaper paper = new TuPaper();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (param.getTestMode() == 0) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TuPaper::getTuCourseId, (Object)param.getTuCourseId())).eq(TuPaper::getResult, (Object)0)).isNull(TuPaper::getScore)).eq(TuPaper::getIsValid, (Object)Constant.YES)).orderByDesc(TuPaper::getCreateTime)).last("limit 1");
        }
        if (param.getTestMode() == 1) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TuPaper::getTrainingId, (Object)param.getTid())).eq(TuPaper::getEnrollDetailId, (Object)paper.getEnrollDetailId())).eq(TuPaper::getResult, (Object)0)).isNull(TuPaper::getScore)).eq(TuPaper::getIsValid, (Object)Constant.YES)).orderByDesc(TuPaper::getCreateTime)).last("limit 1");
        }
        if ((unansweredPaper = (TuPaper)this.getOne((Wrapper)wrapper)) != null) {
            paper = unansweredPaper;
            paper.setIsNewPaper(Boolean.valueOf(false));
        } else {
            paper.setUserId(param.getUserId()).setTrainingId(param.getTid()).setEnrollDetailId(param.getEnrollDetailId()).setTuCourseId(param.getTuCourseId()).setCourseId(param.getCourseId()).setPassScore(param.getPassScore()).setTestMode(param.getTestMode()).setResult(Integer.valueOf(0)).setScore(null).setCreateBy(param.getUserId()).setCreateTime(new Date()).setIsNewPaper(Boolean.valueOf(true));
            this.save(paper);
        }
        return paper;
    }

    @Override
    @Transactional
    public ExamPaperDataVo getExamQuestionsForOrig(StartExamParam param) {
        TuPaper paper = this.initTuPaperForGetExamQuestions(param);
        List<Object> paperQuestionList = new ArrayList();
        if (param.getTestPaperUsage().equals(PaperUsageEnum.LEARNER_COMMON.getValue())) {
            paperQuestionList = this.getEarliestPaperQuestion(param.getTid(), param.getCourseId(), param.getTestMode());
        }
        if (CollUtil.isEmpty(paperQuestionList)) {
            paperQuestionList = this.getQuestionsForOrig(param);
        }
        if (CollUtil.isEmpty(paperQuestionList)) {
            throw new ServiceException("\u672a\u8c03\u53d6\u5230\u76f8\u5339\u914d\u7684\u8bd5\u9898\uff01");
        }
        for (TuPaperQuestion tuPaperQuestion : paperQuestionList) {
            tuPaperQuestion.setTuPaperId(paper.getId());
            tuPaperQuestion.setUserId(param.getUserId());
        }
        if (paper.getIsNewPaper().booleanValue()) {
            paperQuestionList.forEach(item -> {
                item.setId(null);
                item.setCreateTime(new Date());
                item.setUpdateTime(new Date());
            });
            this.paperQuestionService.saveBatch(paperQuestionList);
        }
        List examQuestionList = this.tuPaperQuestionConverter.toExamQuestionsDataVoList(paperQuestionList);
        examQuestionList.forEach(item -> item.setAnswerLength(Integer.valueOf(item.getAnswer() == null ? 0 : item.getAnswer().length())));
        this.redisUtil.addHashCache((Object)"TUPAPER", (Object)RedisKey.getTuPaper((Long)paper.getId()), (Object)JSON.toJSONString((Object)paper), 1L, TimeUnit.DAYS);
        this.redisUtil.addHashCache((Object)"TUPAPERQUESTION", (Object)RedisKey.getTuPaperQuestion((Long)paper.getId()), (Object)JSON.toJSONString(paperQuestionList), 1L, TimeUnit.DAYS);
        return new ExamPaperDataVo().setTid(param.getTid()).setEnrollDetailId(param.getEnrollDetailId()).setTuCourseId(param.getTuCourseId()).setPaperStructureId(param.getPaperStructureId()).setTuPaperId(paper.getId()).setQuestions(examQuestionList);
    }

    @Override
    @Transactional(readOnly=false)
    public ExamPaperDataVo getReExamQuestions(StartExamParam param) {
        TuPaper paper = this.initTuPaperForGetExamQuestions(param);
        List<Object> paperQuestionList = new ArrayList();
        if (!paper.getIsNewPaper().booleanValue()) {
            paperQuestionList = this.paperQuestionService.getByPaperId(paper.getId());
        } else {
            if (param.getRetestSetting().equals(PaperReTestSettingEnum.ORIGINAL_QUESTION.getValue()) || param.getRetestSetting().equals(PaperReTestSettingEnum.ORIGINAL_MESS_ORDER.getValue())) {
                paperQuestionList = this.getLastTimePaperQuestion(param);
            }
            if (param.getRetestSetting().equals(PaperReTestSettingEnum.NEW_PAPER.getValue()) || CollUtil.isEmpty(paperQuestionList)) {
                paperQuestionList = param.getTrainTarget() == 0 ? this.getQuestionsByFactorsAndPaperStructure(param) : this.getQuestionsForOrig(param);
            }
        }
        if (CollUtil.isEmpty(paperQuestionList)) {
            throw new ServiceException("\u672a\u8c03\u53d6\u5230\u76f8\u5339\u914d\u7684\u8bd5\u9898\uff01");
        }
        paperQuestionList.forEach(item -> {
            item.setTuPaperId(paper.getId());
            item.setUserId(param.getUserId());
        });
        if (paper.getIsNewPaper().booleanValue()) {
            paperQuestionList.forEach(item -> {
                item.setId(null);
                item.setUserAnswer(null);
                item.setCreateTime(new Date());
                item.setUpdateTime(new Date());
            });
            this.paperQuestionService.saveBatch(paperQuestionList);
        }
        List examQuestionList = this.tuPaperQuestionConverter.toExamQuestionsDataVoList(paperQuestionList);
        examQuestionList.forEach(item -> item.setAnswerLength(Integer.valueOf(item.getAnswer() == null ? 0 : item.getAnswer().length())));
        return new ExamPaperDataVo().setTid(param.getTid()).setEnrollDetailId(param.getEnrollDetailId()).setTuCourseId(param.getTuCourseId()).setPaperStructureId(param.getPaperStructureId()).setTuPaperId(paper.getId()).setQuestions(examQuestionList);
    }

    @Override
    public Integer checkForAdequacy(List<String> workTypes, Long paperStructId) {
        Collections.shuffle(workTypes);
        PaperStructure paperStructure = (PaperStructure)this.paperStructureService.getById(paperStructId);
        List<Question> singleQuestions = this.questionService.getExamQuestions(workTypes, QuestionTypeEnum.SINGLE_CHOICE.getValue(), paperStructure.getSingleNum());
        if (singleQuestions.size() < paperStructure.getSingleNum()) {
            return 1;
        }
        List<Question> multipleQuestions = this.questionService.getExamQuestions(workTypes, QuestionTypeEnum.MULTIPLE_CHOICE.getValue(), paperStructure.getMultipleNum());
        if (multipleQuestions.size() < paperStructure.getMultipleNum()) {
            return 2;
        }
        List<Question> completionQuestions = this.questionService.getExamQuestions(workTypes, QuestionTypeEnum.COMPLETION.getValue(), paperStructure.getCompletionNum());
        if (completionQuestions.size() < paperStructure.getCompletionNum()) {
            return 3;
        }
        return 0;
    }

    public List<Question> getQuestionsByWorkTypesAndPaperStructure(List<String> workTypes, StartExamParam structure) {
        ArrayList<Question> questionsData = new ArrayList<Question>();
        Collections.shuffle(workTypes);
        List<Question> singleQuestions = this.questionService.getExamQuestions(workTypes, QuestionTypeEnum.SINGLE_CHOICE.getValue(), structure.getSingleNum());
        List<Question> multipleQuestions = this.questionService.getExamQuestions(workTypes, QuestionTypeEnum.MULTIPLE_CHOICE.getValue(), structure.getMultipleNum());
        List<Question> completionQuestions = this.questionService.getExamQuestions(workTypes, QuestionTypeEnum.COMPLETION.getValue(), structure.getCompletionNum());
        questionsData.addAll(singleQuestions);
        questionsData.addAll(multipleQuestions);
        questionsData.addAll(completionQuestions);
        return questionsData;
    }

    public List<TuPaperQuestion> getQuestionsByFactorsAndPaperStructure(StartExamParam param) {
        ArrayList<Object> questionsData = new ArrayList<Object>();
        Collections.shuffle(param.getRiskFactorCodes());
        List<Object> questionList = new ArrayList<Question>();
        if (param.getTestMode() == 0) {
            questionList = this.questionService.getQuestionFromRelation(new ArrayList<String>(Collections.singletonList(param.getCourseId().toString())));
        } else {
            ArrayList<Question> list = new ArrayList<Question>(this.questionService.getQuestionFromRelation(param.getCourseIdList()));
            questionList.addAll(list);
        }
        List singleList = questionList.stream().filter(v -> v.getQuestionType() == QuestionTypeEnum.SINGLE_CHOICE.getValue()).collect(Collectors.toList());
        List multipleList = questionList.stream().filter(v -> v.getQuestionType() == QuestionTypeEnum.MULTIPLE_CHOICE.getValue()).collect(Collectors.toList());
        List completionList = questionList.stream().filter(v -> v.getQuestionType() == QuestionTypeEnum.COMPLETION.getValue()).collect(Collectors.toList());
        List judgeList = questionList.stream().filter(v -> v.getQuestionType() == QuestionTypeEnum.JUDGE.getValue()).collect(Collectors.toList());
        if (singleList.size() < param.getSingleNum()) {
            List<Question> leftSingleQuestions = this.questionService.getExamQuestionsFromRelation(param, QuestionTypeEnum.SINGLE_CHOICE.getValue(), param.getSingleNum() - singleList.size());
            if (leftSingleQuestions.size() + singleList.size() < param.getSingleNum()) {
                throw new ServiceException("\u65e0\u6cd5\u751f\u6210\u8bd5\u5377\u3010001\u3011\uff01\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458");
            }
            questionsData.addAll(singleList);
            questionsData.addAll(leftSingleQuestions);
        } else {
            for (int i = 0; i < param.getSingleNum(); ++i) {
                questionsData.add(singleList.get(i));
            }
        }
        if (multipleList.size() < param.getMultipleNum()) {
            List<Question> leftMultipleQuestions = this.questionService.getExamQuestionsFromRelation(param, QuestionTypeEnum.MULTIPLE_CHOICE.getValue(), param.getMultipleNum() - multipleList.size());
            if (leftMultipleQuestions.size() + multipleList.size() < param.getMultipleNum()) {
                throw new ServiceException("\u65e0\u6cd5\u751f\u6210\u8bd5\u5377\u3010002\u3011\uff01\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458");
            }
            questionsData.addAll(multipleList);
            questionsData.addAll(leftMultipleQuestions);
        } else {
            for (int i = 0; i < param.getMultipleNum(); ++i) {
                questionsData.add(multipleList.get(i));
            }
        }
        if (completionList.size() < param.getCompletionNum()) {
            List<Question> leftCompletionQuestions = this.questionService.getExamQuestionsFromRelation(param, QuestionTypeEnum.COMPLETION.getValue(), param.getCompletionNum() - completionList.size());
            if (leftCompletionQuestions.size() + completionList.size() < param.getCompletionNum()) {
                throw new ServiceException("\u65e0\u6cd5\u751f\u6210\u8bd5\u5377\u3010003\u3011\uff01\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458");
            }
            questionsData.addAll(completionList);
            questionsData.addAll(leftCompletionQuestions);
        } else {
            for (int i = 0; i < param.getCompletionNum(); ++i) {
                questionsData.add(completionList.get(i));
            }
        }
        if (judgeList.size() < param.getJudgeNum()) {
            List<Question> leftJudgeQuestions = this.questionService.getExamQuestionsFromRelation(param, QuestionTypeEnum.JUDGE.getValue(), param.getJudgeNum() - judgeList.size());
            if (leftJudgeQuestions.size() + judgeList.size() < param.getJudgeNum()) {
                throw new ServiceException("\u65e0\u6cd5\u751f\u6210\u8bd5\u5377\u3010004\u3011\uff01\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458");
            }
            questionsData.addAll(judgeList);
            questionsData.addAll(leftJudgeQuestions);
        } else {
            for (int i = 0; i < param.getJudgeNum(); ++i) {
                questionsData.add(judgeList.get(i));
            }
        }
        return this.questionConverter.entityList2PaperQuestionList(questionsData);
    }

    public List<TuPaperQuestion> getQuestionsForOrig(StartExamParam param) {
        ArrayList<Object> questionsData = new ArrayList<Object>();
        List<Object> questionList = new ArrayList<Question>();
        if (param.getTestMode() == 0) {
            questionList = this.questionService.getQuestionFromRelation(new ArrayList<String>(Collections.singletonList(param.getCourseId().toString())));
        } else {
            HashSet<Question> set = new HashSet<Question>(this.questionService.getQuestionFromRelation(param.getCourseIdList()));
            questionList.addAll(set);
        }
        List singleList = questionList.stream().filter(v -> v.getQuestionType() == QuestionTypeEnum.SINGLE_CHOICE.getValue()).collect(Collectors.toList());
        List multipleList = questionList.stream().filter(v -> v.getQuestionType() == QuestionTypeEnum.MULTIPLE_CHOICE.getValue()).collect(Collectors.toList());
        List completionList = questionList.stream().filter(v -> v.getQuestionType() == QuestionTypeEnum.COMPLETION.getValue()).collect(Collectors.toList());
        if (singleList.size() < param.getSingleNum()) {
            List<Question> leftSingleQuestions = this.questionService.getExamQuestionsForOrig(param, QuestionTypeEnum.SINGLE_CHOICE.getValue(), param.getSingleNum() - singleList.size());
            if (leftSingleQuestions.size() + singleList.size() < param.getSingleNum()) {
                throw new ServiceException("\u65e0\u6cd5\u751f\u6210\u8bd5\u5377\u3010001\u3011\uff01\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458");
            }
            questionsData.addAll(singleList);
            questionsData.addAll(leftSingleQuestions);
        } else {
            for (int i = 0; i < param.getSingleNum(); ++i) {
                questionsData.add(singleList.get(i));
            }
        }
        if (multipleList.size() < param.getMultipleNum()) {
            List<Question> leftMultipleQuestions = this.questionService.getExamQuestionsForOrig(param, QuestionTypeEnum.MULTIPLE_CHOICE.getValue(), param.getMultipleNum() - multipleList.size());
            if (leftMultipleQuestions.size() + multipleList.size() < param.getMultipleNum()) {
                throw new ServiceException("\u65e0\u6cd5\u751f\u6210\u8bd5\u5377\u3010002\u3011\uff01\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458");
            }
            questionsData.addAll(multipleList);
            questionsData.addAll(leftMultipleQuestions);
        } else {
            for (int i = 0; i < param.getMultipleNum(); ++i) {
                questionsData.add(multipleList.get(i));
            }
        }
        if (completionList.size() < param.getCompletionNum()) {
            List<Question> leftCompletionQuestions = this.questionService.getExamQuestionsForOrig(param, QuestionTypeEnum.COMPLETION.getValue(), param.getCompletionNum() - completionList.size());
            if (leftCompletionQuestions.size() + completionList.size() < param.getCompletionNum()) {
                throw new ServiceException("\u65e0\u6cd5\u751f\u6210\u8bd5\u5377\u3010003\u3011\uff01\u8bf7\u8054\u7cfb\u540e\u53f0\u7ba1\u7406\u5458");
            }
            questionsData.addAll(completionList);
            questionsData.addAll(leftCompletionQuestions);
        } else {
            for (int i = 0; i < param.getCompletionNum(); ++i) {
                questionsData.add(completionList.get(i));
            }
        }
        return this.questionConverter.entityList2PaperQuestionList(questionsData);
    }

    @Cacheable(cacheNames={"QUESTION"}, key="#tid + '_' + #courseId")
    public List<TuPaperQuestion> getEarliestPaperQuestion(Long tid, Long courseId, Integer testMode) {
        QueryWrapper wrapper = Wrappers.query();
        if (testMode == 0) {
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"training_id", (Object)tid)).eq((Object)"course_id", (Object)courseId)).eq((Object)"is_reset", (Object)0)).eq((Object)"is_valid", (Object)Constant.YES);
        } else {
            ((QueryWrapper)wrapper.eq((Object)"training_id", (Object)tid)).eq((Object)"is_valid", (Object)Constant.YES);
        }
        ((QueryWrapper)wrapper.orderByAsc((Object)"create_time")).last("limit 1");
        TuPaper tuPaper = (TuPaper)this.getOne((Wrapper)wrapper);
        if (tuPaper == null) {
            return null;
        }
        return this.paperQuestionService.getByPaperId(tuPaper.getId());
    }

    private List<TuPaperQuestion> getLastTimePaperQuestion(StartExamParam param) {
        QueryWrapper wrapper = Wrappers.query();
        ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wrapper.eq((Object)"training_id", (Object)param.getTid())).eq((Object)"user_id", (Object)param.getUserId())).eq((Object)"test_mode", (Object)param.getTestMode())).eq((Object)"enroll_detail_id", (Object)param.getEnrollDetailId())).ne((Object)"result", (Object)0)).eq((Object)"is_valid", (Object)Constant.YES);
        if (param.getTestMode() == 0) {
            wrapper.eq((Object)"tu_course_id", (Object)param.getTuCourseId());
        } else {
            wrapper.isNull((Object)"tu_course_id");
        }
        ((QueryWrapper)wrapper.orderByDesc((Object)"create_time")).last("limit 1");
        TuPaper tuPaper = (TuPaper)this.getOne((Wrapper)wrapper);
        if (tuPaper == null) {
            return null;
        }
        List<TuPaperQuestion> result = this.paperQuestionService.getByPaperId(tuPaper.getId());
        if (param.getRetestSetting().equals(PaperReTestSettingEnum.ORIGINAL_MESS_ORDER.getValue())) {
            Collections.shuffle(result);
        }
        return result;
    }

    @Override
    @Transactional(readOnly=false)
    public ExamPaperResultVo submitExam(SubmitExamParam param) {
        String tuPaperCache = (String)this.redisUtil.getHashCache((Object)"TUPAPER", (Object)RedisKey.getTuPaper((Long)param.getTuPaperId()));
        TuPaper tuPaper = null == tuPaperCache ? (TuPaper)this.getById(param.getTuPaperId()) : (TuPaper)JSON.parseObject((String)tuPaperCache, TuPaper.class);
        if (tuPaper == null || tuPaper.getPassScore() == null) {
            throw new ServiceException("\u672a\u627e\u5230\u8bd5\u5377\uff01");
        }
        if (tuPaper.getScore() != null) {
            throw new ServiceException("\u8bd5\u5377\u5df2\u7b54\u9898\uff01");
        }
        Integer singleScore = param.getSingleScore();
        Integer multipleScore = param.getMultipleScore();
        Integer completionScore = param.getCompletionScore();
        Integer judgeScore = param.getJudgeScore();
        Integer passScore = tuPaper.getPassScore();
        String paperQuestionCache = (String)this.redisUtil.getHashCache((Object)"TUPAPERQUESTION", (Object)RedisKey.getTuPaperQuestion((Long)param.getTuPaperId()));
        List<TuPaperQuestion> questions = null == paperQuestionCache ? this.paperQuestionService.getByPaperId(param.getTuPaperId()) : JSON.parseArray((String)paperQuestionCache, TuPaperQuestion.class);
        if (CollectionUtils.isEmpty(questions)) {
            throw new ServiceException("\u672a\u627e\u5230\u8bd5\u5377\u8bd5\u9898\uff01");
        }
        questions.forEach(question -> param.getAnswers().forEach(answer -> {
            if (question.getId().equals(answer.getTuPaperQuestionId())) {
                question.setUserAnswer(answer.getUserAnswer());
                String userAnswer = "";
                String rightAnswers = "";
                if (question.getQuestionType() == 1 || question.getQuestionType() == 2) {
                    rightAnswers = Stream.of(question.getAnswer().replaceAll("[^(A-Za-z)]", "").split("")).sorted(Comparator.comparingInt(o -> Character.toLowerCase(o.charAt(0)))).collect(Collectors.joining()).toUpperCase();
                    userAnswer = Stream.of(answer.getUserAnswer().replaceAll("[^(A-Za-z)]", "").split("")).sorted(Comparator.comparingInt(o -> Character.toLowerCase(o.charAt(0)))).collect(Collectors.joining()).toUpperCase();
                } else if (question.getQuestionType() == 3) {
                    userAnswer = answer.getUserAnswer();
                    rightAnswers = question.getAnswer();
                } else {
                    rightAnswers = Stream.of(question.getAnswer().replaceAll(" ", "").replaceAll(",", "").split("")).sorted(Comparator.comparingInt(o -> Character.toLowerCase(o.charAt(0)))).collect(Collectors.joining()).toUpperCase();
                    userAnswer = Stream.of(answer.getUserAnswer().replaceAll(" ", "").replaceAll(",", "").split("")).sorted(Comparator.comparingInt(o -> Character.toLowerCase(o.charAt(0)))).collect(Collectors.joining()).toUpperCase();
                }
                if (rightAnswers.equals(userAnswer)) {
                    question.setJudgeResult(AnswerJudgeResultEnum.CORRECT.getValue());
                    switch (question.getQuestionType()) {
                        case 1: {
                            question.setScore(singleScore);
                            break;
                        }
                        case 2: {
                            question.setScore(multipleScore);
                            break;
                        }
                        case 3: {
                            question.setScore(completionScore);
                            break;
                        }
                        case 4: {
                            question.setScore(judgeScore);
                            break;
                        }
                    }
                } else {
                    question.setJudgeResult(AnswerJudgeResultEnum.WRONG.getValue());
                    question.setScore(Integer.valueOf(0));
                }
            }
        }));
        this.paperQuestionService.updateBatchById(questions);
        Integer totalScore = questions.stream().mapToInt(TuPaperQuestion::getScore).sum();
        Integer resultValue = totalScore >= passScore ? ExamResultEnum.PASSED.getValue() : ExamResultEnum.NO_PASSED.getValue();
        tuPaper.setResult(resultValue);
        tuPaper.setScore(totalScore);
        tuPaper.setTimeCost(param.getTimeCost());
        this.updateById(tuPaper);
        this.redisUtil.delHashCache((Object)"TUPAPER", (Object)RedisKey.getTuPaper((Long)param.getTuPaperId()));
        this.redisUtil.delHashCache((Object)"TUPAPERQUESTION", (Object)RedisKey.getTuPaperQuestion((Long)param.getTuPaperId()));
        return new ExamPaperResultVo().setTuPaperId(param.getTuPaperId()).setQuestions(questions).setExamTime(tuPaper.getCreateTime()).setTimeCost(param.getTimeCost()).setTimeCostStr(DateUtils.formatTime((Object)param.getTimeCost())).setResultValue(resultValue).setScore(tuPaper.getScore()).setTestMode(tuPaper.getTestMode()).setResult(ExamResultEnum.getNameByValue((Integer)resultValue));
    }

    @Override
    public Integer getTrainingAverageScore(Long uid, Long enrollDetailId) {
        return ((TuPaperMapper)this.baseMapper).getTrainingAverageScore(uid, enrollDetailId);
    }

    @Override
    public int getExamPassNumNoRepeat(Long enrollDetailId, Integer trainMode) {
        return ((TuPaperMapper)this.baseMapper).getExamPassNumNoRepeat(enrollDetailId, trainMode);
    }

    @Override
    public long getExamCoursePassCount(Long tuCourseId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)wrapper.eq(TuPaper::getTuCourseId, (Object)tuCourseId)).eq(TuPaper::getResult, (Object)ExamResultEnum.PASSED.getValue());
        return this.count((Wrapper)wrapper);
    }

    @Override
    public long getExamCourseCount(Long tuCourseId) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(TuPaper::getTuCourseId, (Object)tuCourseId)).eq(TuPaper::getIsReset, (Object)0)).isNotNull(TuPaper::getScore);
        return this.count((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void setResetByTuCourseId(List<Long> tuCourseIdList) {
        ((TuPaperMapper)this.baseMapper).setResetByTuCourseId(tuCourseIdList);
    }

    @Override
    @Transactional
    public void setResetByDetailId(List<Long> tuEnrollDetailIdList) {
        ((TuPaperMapper)this.baseMapper).setResetByDetailId(tuEnrollDetailIdList);
    }

    @Override
    @Transactional
    public void delTuPaperAndQuestion(Long tuEnrollDetailId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"enroll_detail_id", (Object)tuEnrollDetailId);
        List papers = this.list((Wrapper)wrapper);
        if (CollectionUtil.isEmpty((Collection)papers)) {
            return;
        }
        List tuPaperIdList = papers.stream().map(TuPaper::getId).collect(Collectors.toList());
        LambdaUpdateWrapper questionWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)questionWrapper.in(TuPaperQuestion::getTuPaperId, tuPaperIdList)).eq(TuPaperQuestion::getIsValid, (Object)Constant.YES)).set(TuPaperQuestion::getIsValid, (Object)Constant.NO);
        this.paperQuestionService.update((Wrapper)questionWrapper);
        LambdaUpdateWrapper tuPaperWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)tuPaperWrapper.eq(TuPaper::getEnrollDetailId, (Object)tuEnrollDetailId)).eq(TuPaper::getIsValid, (Object)Constant.YES)).set(TuPaper::getIsValid, (Object)Constant.NO);
        this.update((Wrapper)tuPaperWrapper);
    }

    @Override
    @Transactional
    public void delTuPaperAndQuestionBatch(List<Long> tuEnrollDetailIds) {
        for (Long tuEnrollDetailId : tuEnrollDetailIds) {
            this.delTuPaperAndQuestion(tuEnrollDetailId);
        }
    }

    @Override
    @Transactional
    public void setIsValidById(Boolean isValid, List<Long> ids) {
        if (CollectionUtil.isEmpty(ids)) {
            return;
        }
        ((TuPaperMapper)this.baseMapper).setIsValidById(isValid, ids);
    }

    @Override
    public List<TuPaper> getDeletedDataByDetailId(Long enrollDetailId) {
        return ((TuPaperMapper)this.baseMapper).getDeletedDataByDetailId(enrollDetailId);
    }

    public void switchStemList(ExamQuestionsDataVo item) {
        ArrayList<String> stemList = new ArrayList<String>();
        String myStr = item.getStem();
        int firstIndex = myStr.indexOf("_");
        int lastIndex = myStr.lastIndexOf("_");
        ArrayList<String> myList = new ArrayList<String>(Arrays.asList(myStr.split("_", -1)));
        int i = 0;
        if (firstIndex == 0) {
            i = 1;
            stemList.add("");
        }
        while (i < myList.size() - 1) {
            stemList.add((String)myList.get(i));
            stemList.add("");
            ++i;
        }
        if (lastIndex + 1 != myStr.length()) {
            stemList.add((String)myList.get(myList.size() - 1));
        }
    }

    @Generated
    public TuPaperServiceImpl() {
    }
}

