/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.question.service.impl;

import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.question.converter.QuestionConverter;
import cn.smarthse.radiationTraining.modules.question.dao.QuestionMapper;
import cn.smarthse.radiationTraining.modules.question.entity.Question;
import cn.smarthse.radiationTraining.modules.question.entity.QuestionRelation;
import cn.smarthse.radiationTraining.modules.question.enums.QuestionTypeEnum;
import cn.smarthse.radiationTraining.modules.question.param.QuestionSearchParam;
import cn.smarthse.radiationTraining.modules.question.param.QuestionSetBatchParam;
import cn.smarthse.radiationTraining.modules.question.param.StartExamParam;
import cn.smarthse.radiationTraining.modules.question.param.importQuestion.ImportQuestionData;
import cn.smarthse.radiationTraining.modules.question.service.IQuestionRelationService;
import cn.smarthse.radiationTraining.modules.question.service.IQuestionService;
import cn.smarthse.radiationTraining.modules.question.vo.QuestionVo;
import cn.smarthse.radiationTraining.modules.sys.entity.SysLog;
import cn.smarthse.radiationTraining.modules.sys.param.sys.SaveSysParam;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ILogProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysOccupationalHazardsProviderService;
import cn.smarthse.radiationTraining.modules.sys.provider.sys.ISysParamProviderService;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.util.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.apache.dubbo.config.annotation.DubboReference;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class QuestionServiceImpl
extends ServiceImpl<QuestionMapper, Question>
implements IQuestionService {
    private final QuestionConverter questionConverter;
    @DubboReference
    private ISysParamProviderService sysParamProviderService;
    @DubboReference
    private ISysOccupationalHazardsProviderService riskFactorsProviderService;
    @DubboReference
    private ILogProviderService logProviderService;
    @Autowired
    private IQuestionRelationService questionRelationService;

    @Override
    public LayuiGridData<QuestionVo> getQuestionPageList(QuestionSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<QuestionVo> list = ((QuestionMapper)this.baseMapper).getQuestionList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    public List<Question> getQuestionListByCourseId(QuestionSearchParam param) {
        return ((QuestionMapper)this.baseMapper).getQuestionListByCourseId(param);
    }

    @Override
    public List<Question> getQuestionFromRelation(List<String> courseIdList) {
        return ((QuestionMapper)this.baseMapper).getQuestionFromRelation(courseIdList);
    }

    @Override
    public List<String> importQuestion(List<ImportQuestionData> list) {
        List data = this.questionConverter.toQuestionInfoList(list);
        List<String> errList = this.checkImportData(data);
        if (!CollectionUtils.isEmpty(errList)) {
            throw new ServiceException(Integer.valueOf(-1), "\u5bfc\u5165\u5931\u8d25\uff01", errList);
        }
        data.stream().forEach(question -> {
            if (question.getQuestionType().equals(QuestionTypeEnum.MULTIPLE_CHOICE.getValue())) {
                String splitAnswer = StringUtils.join(Arrays.asList(question.getAnswer().split("")), (String)",");
                question.setAnswer(splitAnswer);
            }
            if (question.getQuestionType().equals(QuestionTypeEnum.JUDGE.getValue())) {
                question.setOptionA("\u6b63\u786e");
                question.setOptionB("\u9519\u8bef");
            }
        });
        this.addQuestionList(data);
        return null;
    }

    @Override
    public void addQuestion(QuestionVo questionVo) {
        Question question = this.questionConverter.voToEntity(questionVo);
        this.save(question);
        List questionRelationList = questionVo.getQuestionRelationList();
        questionRelationList.stream().forEach(item -> {
            item.setId(null);
            item.setQuestionId(question.getId());
        });
        this.questionRelationService.saveBatch(questionRelationList);
    }

    @Override
    public void updateQuestion(QuestionVo questionVo) {
        Question info = (Question)this.getById(questionVo.getId());
        if (!questionVo.getIsSpecifiedUser().booleanValue() && !Objects.equals(questionVo.getUpdateBy(), info.getCreateBy())) {
            throw new ServiceException("\u65e0\u6cd5\u4fee\u6539\u5176\u4ed6\u8d26\u53f7\u521b\u5efa\u7684\u8bd5\u9898\uff01");
        }
        Question question = this.questionConverter.voToEntity(questionVo);
        this.updateById(question);
        List questionRelationList = questionVo.getQuestionRelationList();
        questionRelationList.stream().forEach(item -> {
            item.setId(null);
            item.setQuestionId(question.getId());
        });
        this.questionRelationService.updateQuestionRelation(question.getId(), questionRelationList);
    }

    @Override
    public void removeQuestionBatch(IdsParam param) {
        List idList = param.getIdList();
        idList.stream().forEach(id -> {
            Question info = (Question)this.getById((Serializable)id);
            if (!param.getIsSpecifiedUser().booleanValue() && !Objects.equals(param.getUpdateBy(), info.getCreateBy())) {
                throw new ServiceException("\u9009\u4e2d\u7684\u6570\u636e\u4e2d\u5305\u542b\u5176\u4ed6\u8d26\u53f7\u521b\u5efa\u7684\u8bd5\u9898\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
            }
        });
        this.removeByIds(idList);
        idList.stream().forEach(questionId -> this.questionRelationService.removeRelationByQid((Long)questionId));
    }

    private void transfFactorNo(List<Question> data) {
        if (!CollectionUtils.isEmpty(data)) {
            data.forEach(item -> {
                if (StringUtil.isNotEmpty((String)item.getSuitableFactorNos())) {
                    List typeNames = Arrays.stream(item.getSuitableFactorNos().split("\uff0c")).map(String::toString).collect(Collectors.toList());
                    String workTypeIds = this.riskFactorsProviderService.getCodesByNames(typeNames);
                    item.setSuitableFactorNos(workTypeIds);
                    item.setStatus(Integer.valueOf(2));
                }
            });
        }
    }

    private void transfFactorNoNames(List<QuestionVo> data) {
        if (!CollectionUtils.isEmpty(data)) {
            data.forEach(item -> {
                if (StringUtil.isNotEmpty((String)item.getSuitableFactorNos())) {
                    List typeIds = Arrays.stream(item.getSuitableFactorNos().split(",")).map(String::toString).collect(Collectors.toList());
                    List factorNoNames = this.riskFactorsProviderService.getNamesByCodes(typeIds);
                    String factorNoNamesStr = String.join((CharSequence)"\uff0c", factorNoNames);
                    item.setFactorNoNames(factorNoNamesStr);
                }
            });
        }
    }

    @Override
    public List<String> checkImportData(List<Question> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            throw new ServiceException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList<String> msgList = new ArrayList<String>();
        Iterator<Question> iterator = dataList.iterator();
        int rowIndex = 3;
        while (iterator.hasNext()) {
            char charAnswer;
            String upperCaseAnswer;
            Question item = iterator.next();
            if (StringUtil.isEmpty((String)item.getStem())) {
                msgList.add(String.format("\u7b2c%s\u884c \u9898\u5e72 \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (StringUtil.isEmpty((String)item.getAnalysis())) {
                msgList.add(String.format("\u7b2c%s\u884c \u89e3\u6790 \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (StringUtil.isEmpty((String)item.getSuitablePersonTypes())) {
                msgList.add(String.format("\u7b2c%s\u884c \u4eba\u5458\u7c7b\u578b \u4e3a\u7a7a\uff01", rowIndex));
            } else if (item.getSuitablePersonTypes().equals("\u975e\u6cd5\u6570\u636e")) {
                msgList.add(String.format("\u7b2c%s\u884c \u4eba\u5458\u7c7b\u578b \u683c\u5f0f\u672a\u6309\u8981\u6c42\u586b\u5199\uff01", rowIndex));
            }
            if (item.getQuestionType() == null) {
                msgList.add(String.format("\u7b2c%s\u884c \u9898\u578b \u4e3a\u7a7a\uff01", rowIndex));
                ++rowIndex;
                continue;
            }
            if (StringUtil.isEmpty((String)item.getOptionA()) && !item.getQuestionType().equals(QuestionTypeEnum.COMPLETION.getValue()) && !item.getQuestionType().equals(QuestionTypeEnum.JUDGE.getValue())) {
                msgList.add(String.format("\u7b2c%s\u884c \u9009\u9879A \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (StringUtil.isEmpty((String)item.getOptionB()) && !item.getQuestionType().equals(QuestionTypeEnum.COMPLETION.getValue()) && !item.getQuestionType().equals(QuestionTypeEnum.JUDGE.getValue())) {
                msgList.add(String.format("\u7b2c%s\u884c \u9009\u9879B \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (item.getQuestionType().equals(QuestionTypeEnum.MULTIPLE_CHOICE.getValue()) && StringUtil.isEmpty((String)item.getOptionC())) {
                msgList.add(String.format("\u7b2c%s\u884c \u9009\u9879C \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (item.getQuestionType().equals(QuestionTypeEnum.MULTIPLE_CHOICE.getValue()) && StringUtil.isEmpty((String)item.getOptionD())) {
                msgList.add(String.format("\u7b2c%s\u884c \u9009\u9879D \u4e3a\u7a7a\uff01", rowIndex));
            }
            if (StringUtil.isEmpty((String)item.getAnswer())) {
                msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848 \u4e3a\u7a7a\uff01", rowIndex));
            } else if (Objects.equals(item.getQuestionType(), QuestionTypeEnum.SINGLE_CHOICE.getValue())) {
                upperCaseAnswer = item.getAnswer().toUpperCase();
                if (upperCaseAnswer.length() > 1) {
                    msgList.add(String.format("\u7b2c%s\u884c \u5355\u9009\u9898\u4e0d\u80fd\u586b\u5199\u591a\u4e2a\u7b54\u6848\uff01", rowIndex));
                }
                if ((charAnswer = upperCaseAnswer.charAt(0)) < 'A' || charAnswer > 'G') {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u4e3a\u975e\u6cd5\u5b57\u7b26\uff01", rowIndex));
                }
                if (item.getAnswer().equals("A") && StringUtil.isEmpty((String)item.getOptionA())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879A \u4e3a\u7a7a\uff01", rowIndex));
                } else if (item.getAnswer().equals("B") && StringUtil.isEmpty((String)item.getOptionB())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879B \u4e3a\u7a7a\uff01", rowIndex));
                } else if (item.getAnswer().equals("C") && StringUtil.isEmpty((String)item.getOptionC())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879C \u4e3a\u7a7a\uff01", rowIndex));
                } else if (item.getAnswer().equals("D") && StringUtil.isEmpty((String)item.getOptionD())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879D \u4e3a\u7a7a\uff01", rowIndex));
                } else if (item.getAnswer().equals("E") && StringUtil.isEmpty((String)item.getOptionE())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879E \u4e3a\u7a7a\uff01", rowIndex));
                } else if (item.getAnswer().equals("F") && StringUtil.isEmpty((String)item.getOptionF())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879F \u4e3a\u7a7a\uff01", rowIndex));
                } else if (item.getAnswer().equals("G") && StringUtil.isEmpty((String)item.getOptionG())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879G \u4e3a\u7a7a\uff01", rowIndex));
                }
            } else if (Objects.equals(item.getQuestionType(), QuestionTypeEnum.MULTIPLE_CHOICE.getValue())) {
                upperCaseAnswer = Stream.of(item.getAnswer().replaceAll("[^(A-Za-z)]", "").split("")).collect(Collectors.joining()).toUpperCase();
                if (upperCaseAnswer.length() < item.getAnswer().length()) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u5305\u542b\u4e86\u975e\u5b57\u6bcd\u6587\u5b57\uff01", rowIndex));
                }
                char[] charAnswerArray = upperCaseAnswer.toCharArray();
                for (int i = 0; i < charAnswerArray.length; ++i) {
                    if (charAnswerArray[i] >= 'A' && charAnswerArray[i] <= 'G') continue;
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u4e3a\u975e\u6cd5\u5b57\u7b26\uff01", rowIndex));
                }
                if (item.getAnswer().contains("A") && StringUtil.isEmpty((String)item.getOptionA())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879A \u4e3a\u7a7a\uff01", rowIndex));
                }
                if (item.getAnswer().contains("B") && StringUtil.isEmpty((String)item.getOptionB())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879B \u4e3a\u7a7a\uff01", rowIndex));
                }
                if (item.getAnswer().contains("C") && StringUtil.isEmpty((String)item.getOptionC())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879C \u4e3a\u7a7a\uff01", rowIndex));
                }
                if (item.getAnswer().contains("D") && StringUtil.isEmpty((String)item.getOptionD())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879D \u4e3a\u7a7a\uff01", rowIndex));
                }
                if (item.getAnswer().contains("E") && StringUtil.isEmpty((String)item.getOptionE())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879E \u4e3a\u7a7a\uff01", rowIndex));
                }
                if (item.getAnswer().contains("F") && StringUtil.isEmpty((String)item.getOptionF())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879F \u4e3a\u7a7a\uff01", rowIndex));
                }
                if (item.getAnswer().contains("G") && StringUtil.isEmpty((String)item.getOptionG())) {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u9009\u9879G \u4e3a\u7a7a\uff01", rowIndex));
                }
            } else if (Objects.equals(item.getQuestionType(), QuestionTypeEnum.JUDGE.getValue())) {
                upperCaseAnswer = item.getAnswer().toUpperCase();
                if (upperCaseAnswer.length() > 1) {
                    msgList.add(String.format("\u7b2c%s\u884c \u5355\u9009\u9898\u4e0d\u80fd\u586b\u5199\u591a\u4e2a\u7b54\u6848\uff01", rowIndex));
                }
                if ((charAnswer = upperCaseAnswer.charAt(0)) != 'A' && charAnswer != 'B') {
                    msgList.add(String.format("\u7b2c%s\u884c \u7b54\u6848\u4e3a\u975e\u6cd5\u5b57\u7b26\uff01", rowIndex));
                }
            }
            ++rowIndex;
        }
        return msgList;
    }

    @Override
    public void addQuestionList(List<Question> questions) {
        questions.stream().forEach(question -> question.setStatus(Integer.valueOf(1)));
        if (!CollectionUtils.isEmpty(questions)) {
            this.saveBatch(questions);
        }
        questions.stream().forEach(question -> {
            ArrayList relationList = new ArrayList();
            List<String> personTypeCodeList = Arrays.asList(question.getSuitablePersonTypes().split(","));
            personTypeCodeList.stream().forEach(personTypeCode -> {
                QuestionRelation relation = new QuestionRelation();
                relation.setQuestionId(question.getId());
                relation.setRelationCode(personTypeCode);
                if (Objects.equals(personTypeCode, "200001")) {
                    relation.setRelationName("\u4e3b\u8981\u8d1f\u8d23\u4eba");
                } else if (Objects.equals(personTypeCode, "200002")) {
                    relation.setRelationName("\u804c\u4e1a\u536b\u751f\u7ba1\u7406\u4eba\u5458");
                } else if (Objects.equals(personTypeCode, "300002")) {
                    relation.setRelationName("\u653e\u5c04\u5de5\u4f5c\u4eba\u5458");
                }
                relation.setRelationType("3");
                relationList.add(relation);
            });
            this.questionRelationService.saveBatch(relationList);
        });
    }

    @Override
    public List<Question> getExamQuestions(List<String> workTypes, Integer questionType, Integer questionNum) {
        if (CollectionUtils.isEmpty(workTypes) || questionType == null || questionNum == null) {
            throw new ServiceException("\u53c2\u6570\u7f3a\u5931\uff01");
        }
        return ((QuestionMapper)this.baseMapper).getExamQuestions(workTypes, questionType, questionNum);
    }

    @Override
    public List<Question> getExamQuestionsByRiskFactor(StartExamParam param, Integer questionType, Integer questionNum) {
        if (CollectionUtils.isEmpty((Collection)param.getRiskFactorCodes()) || questionType == null || questionNum == null) {
            throw new ServiceException("\u53c2\u6570\u7f3a\u5931\uff01");
        }
        return ((QuestionMapper)this.baseMapper).getExamQuestionsByRiskFactor(param, questionType, questionNum);
    }

    @Override
    public List<Question> getExamQuestionsFromRelation(StartExamParam param, Integer questionType, Integer questionNum) {
        if (CollectionUtils.isEmpty((Collection)param.getRiskFactorCodes()) || CollectionUtils.isEmpty((Collection)param.getIndustryCodes()) || questionType == null || questionNum == null) {
            throw new ServiceException("\u53c2\u6570\u7f3a\u5931\uff01");
        }
        return ((QuestionMapper)this.baseMapper).getExamQuestionsByMatch(param, questionType, questionNum);
    }

    @Override
    public List<Question> getExamQuestionsForOrig(StartExamParam param, Integer questionType, Integer questionNum) {
        if (CollectionUtils.isEmpty((Collection)param.getPersonTypeCodes()) || questionType == null || questionNum == null) {
            throw new ServiceException("\u53c2\u6570\u7f3a\u5931\uff01");
        }
        return ((QuestionMapper)this.baseMapper).getExamQuestionsForOrig(param, questionType, questionNum);
    }

    @Override
    public QuestionVo getQuestionDetailById(Long questionId) {
        Question question = (Question)this.getById(questionId);
        if (question == null) {
            throw new ServiceException("\u8bd5\u9898\u4e0d\u5b58\u5728\uff01");
        }
        QuestionVo questionVo = new QuestionVo();
        BeanUtils.copyProperties((Object)question, (Object)questionVo);
        questionVo.setQuestionRelationList(this.questionRelationService.getRelationByQid(questionId));
        return questionVo;
    }

    @Override
    public void setBatch(QuestionSetBatchParam param) {
        ArrayList sbList = new ArrayList();
        param.getIds().stream().forEach(id -> {
            Question info = (Question)this.getById((Serializable)id);
            if (!param.getIsSpecifiedUser().booleanValue() && !Objects.equals(param.getUpdateBy(), info.getCreateBy())) {
                throw new ServiceException("\u9009\u4e2d\u7684\u6570\u636e\u4e2d\u5305\u542b\u5176\u4ed6\u8d26\u53f7\u521b\u5efa\u7684\u8bd5\u9898\uff0c\u65e0\u6cd5\u4fee\u6539\uff01");
            }
            if (param.getStatus() != null && param.getStatus().equals(2)) {
                Boolean hasEmpty = false;
                StringBuilder sb = new StringBuilder();
                sb.append("\u9898\u5e72\u4e3a\uff1a[" + info.getStem() + "...]\uff0c\u5fc5\u586b\u9879");
                if (StringUtils.isEmpty((String)info.getSuitablePersonTypes())) {
                    sb.append("\u9002\u7528\u4eba\u5458\u7c7b\u522b\u3001");
                    hasEmpty = true;
                }
                if (StringUtils.isEmpty((String)info.getSuitableIndustryCodes()) && !StringUtils.isEmpty((String)info.getSuitablePersonTypes()) && !info.getSuitablePersonTypes().contains("300002")) {
                    sb.append("\u9002\u7528\u884c\u4e1a\u7c7b\u522b\u3001");
                    hasEmpty = true;
                }
                if (StringUtils.isEmpty((String)info.getSuitableFactorNos())) {
                    sb.append("\u9002\u7528\u5371\u5bb3\u56e0\u7d20\u3001");
                    hasEmpty = true;
                }
                if (StringUtils.isEmpty((String)info.getStem())) {
                    sb.append("\u9898\u5e72\u3001");
                    hasEmpty = true;
                }
                if (info.getStatus() == null) {
                    sb.append("\u8bd5\u9898\u72b6\u6001\u3001");
                    hasEmpty = true;
                }
                if (StringUtils.isEmpty((String)info.getOptionA()) && !info.getQuestionType().equals(QuestionTypeEnum.COMPLETION.getValue()) && !info.getQuestionType().equals(QuestionTypeEnum.JUDGE.getValue())) {
                    sb.append("\u9009\u9879A\u3001");
                    hasEmpty = true;
                }
                if (StringUtils.isEmpty((String)info.getOptionB()) && !info.getQuestionType().equals(QuestionTypeEnum.COMPLETION.getValue()) && !info.getQuestionType().equals(QuestionTypeEnum.JUDGE.getValue())) {
                    sb.append("\u9009\u9879B");
                    hasEmpty = true;
                }
                if (hasEmpty.booleanValue()) {
                    if (sb.substring(sb.length() - 1).equals("\u3001")) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    sb.append("\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                    sbList.add(sb);
                }
            }
        });
        if (sbList.size() > 0) {
            throw new ServiceException(Integer.valueOf(-1), "\u5fc5\u586b\u9879\u6821\u9a8c", sbList);
        }
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.in(Question::getId, (Collection)param.getIds());
        if (StringUtils.isNotEmpty((String)param.getSuitableFactorNos())) {
            updateWrapper.set(Question::getSuitableFactorNos, (Object)param.getSuitableFactorNos());
        }
        if (StringUtils.isNotEmpty((String)param.getSuitableIndustryCodes())) {
            updateWrapper.set(Question::getSuitableIndustryCodes, (Object)param.getSuitableIndustryCodes());
        }
        if (StringUtils.isNotEmpty((String)param.getSuitableCourseIds())) {
            updateWrapper.set(Question::getSuitableCourseIds, (Object)param.getSuitableCourseIds());
        }
        if (StringUtils.isNotEmpty((String)param.getFactorNoNames())) {
            updateWrapper.set(Question::getFactorNoNames, (Object)param.getFactorNoNames());
        }
        if (StringUtils.isNotEmpty((String)param.getIndustryCodeNames())) {
            updateWrapper.set(Question::getIndustryCodeNames, (Object)param.getIndustryCodeNames());
        }
        if (StringUtils.isNotEmpty((String)param.getSuitableCourseNames())) {
            updateWrapper.set(Question::getSuitableCourseNames, (Object)param.getSuitableCourseNames());
        }
        if (param.getStatus() != null) {
            updateWrapper.set(Question::getStatus, (Object)param.getStatus());
        }
        updateWrapper.set(Question::getUpdateBy, (Object)param.getUpdateBy());
        updateWrapper.set(Question::getUpdateName, (Object)param.getUpdateName());
        if (StringUtils.isNotEmpty((String)param.getSuitableCourseIds()) || StringUtils.isNotEmpty((String)param.getSuitableIndustryCodes()) && StringUtils.isNotEmpty((String)param.getSuitableFactorNos())) {
            updateWrapper.set(Question::getStatus, (Object)2);
        }
        this.update((Wrapper)updateWrapper);
        if (!CollectionUtils.isEmpty((Collection)param.getQuestionRelationList())) {
            param.getIds().stream().forEach(questionId -> this.questionRelationService.updateRelationByType((Long)questionId, param.getQuestionRelationList(), param.getRelationType()));
        }
    }

    @Override
    public void testDubboTransaction() {
        SaveSysParam param = new SaveSysParam();
        param.setName("\u6d4b\u8bd5\u4e8b\u52a120220804");
        this.sysParamProviderService.saveParam(param);
        SysLog sysLog = new SysLog();
        sysLog.setTitle("title20220804");
        this.logProviderService.addLog(sysLog);
        int a = 10 / 0;
    }

    @Generated
    public QuestionServiceImpl(QuestionConverter questionConverter) {
        this.questionConverter = questionConverter;
    }
}

