/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.question.service.impl;

import cn.smarthse.radiationTraining.modules.question.dao.QuestionRelationMapper;
import cn.smarthse.radiationTraining.modules.question.entity.QuestionRelation;
import cn.smarthse.radiationTraining.modules.question.service.IQuestionRelationService;
import cn.smarthse.radiationTraining.modules.question.vo.SpecialQuestionStatisticsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class QuestionRelationServiceImpl
extends ServiceImpl<QuestionRelationMapper, QuestionRelation>
implements IQuestionRelationService {
    @Override
    public List<QuestionRelation> getRelationByQid(Long questionId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"question_id", (Object)questionId);
        return this.list((Wrapper)wrapper);
    }

    @Override
    @Transactional
    public void updateQuestionRelation(Long questionId, List<QuestionRelation> relationList) {
        this.removeRelationByQid(questionId);
        relationList.stream().forEach(relation -> {
            relation.setId(null);
            relation.setQuestionId(questionId);
        });
        this.saveBatch(relationList);
    }

    @Override
    public void updateRelationByType(Long questionId, List<QuestionRelation> relationList, String relationType) {
        QueryWrapper wrapper = new QueryWrapper();
        ((QueryWrapper)wrapper.eq((Object)"question_id", (Object)questionId)).eq((Object)"relation_type", (Object)relationType);
        this.remove((Wrapper)wrapper);
        relationList.stream().forEach(relation -> {
            relation.setId(null);
            relation.setQuestionId(questionId);
        });
        this.saveBatch(relationList);
    }

    @Override
    @Transactional
    public void removeRelationByQid(Long questionId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"question_id", (Object)questionId);
        this.remove((Wrapper)wrapper);
    }

    @Override
    public SpecialQuestionStatisticsVo getSpecialQuestionNum(String code, Integer type) {
        return ((QuestionRelationMapper)this.baseMapper).getSpecialQuestionNum(code, type);
    }

    @Generated
    public QuestionRelationServiceImpl() {
    }
}

