/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.question.service.impl;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridParam;
import cn.smarthse.radiationTraining.modules.question.dao.PaperStructureMapper;
import cn.smarthse.radiationTraining.modules.question.entity.PaperStructure;
import cn.smarthse.radiationTraining.modules.question.param.PaperStructureParam;
import cn.smarthse.radiationTraining.modules.question.param.PaperStructureSearchParam;
import cn.smarthse.radiationTraining.modules.question.service.IPaperStructureService;
import cn.smarthse.radiationTraining.modules.question.vo.PaperStructureVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class PaperStructureServiceImpl
extends ServiceImpl<PaperStructureMapper, PaperStructure>
implements IPaperStructureService {
    @Override
    public LayuiGridData<PaperStructureVo> getPaperStructureList(PaperStructureSearchParam param) {
        PageHelper.startPage((int)param.getPage(), (int)param.getLimit());
        List<PaperStructureVo> list = ((PaperStructureMapper)this.baseMapper).getPaperStructureList(param);
        return new LayuiGridData((Page)list, (LayuiGridParam)param);
    }

    @Override
    @Transactional(readOnly=false)
    public boolean updateStatus(Long id, Integer status) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)id)).set((Object)"status", (Object)status);
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    @Transactional
    public boolean updateIsSpecial(PaperStructureParam param) {
        UpdateWrapper updateWrapper = new UpdateWrapper();
        ((UpdateWrapper)((UpdateWrapper)updateWrapper.eq((Object)"id", (Object)param.getId())).set((Object)"is_special", (Object)param.getIsSpecial())).set((Object)"update_by", (Object)param.getLoginUserId());
        return this.update((Wrapper)updateWrapper);
    }

    @Override
    public List<PaperStructure> selectBatchIds(List<Long> ids) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        return ((PaperStructureMapper)this.baseMapper).selectBatchIds(ids);
    }

    @Override
    public boolean isSelectedInCourseItem(Long paperStructureId) {
        int num = ((PaperStructureMapper)this.baseMapper).getCourseNumByStructId(paperStructureId);
        return num != 0;
    }

    @Override
    public boolean isSelectedInTrain(Long paperStructureId) {
        int num = ((PaperStructureMapper)this.baseMapper).getTrainNumByStructId(paperStructureId);
        return num != 0;
    }

    @Override
    public PaperStructureVo getVoById(Long paperStructureId) {
        PaperStructure ps = (PaperStructure)((PaperStructureMapper)this.baseMapper).selectById(paperStructureId);
        if (ps == null) {
            return null;
        }
        PaperStructureVo vo = new PaperStructureVo();
        vo.setId(ps.getId());
        vo.setStructName(ps.getStructName());
        vo.setWay(String.valueOf(ps.getWay()));
        vo.setSingleNum(ps.getSingleNum());
        vo.setMultipleNum(ps.getMultipleNum());
        vo.setCompletionNum(ps.getCompletionNum());
        vo.setJudgeNum(ps.getJudgeNum());
        vo.setSingleScore(ps.getSingleScore());
        vo.setMultipleScore(ps.getMultipleScore());
        vo.setCompletionScore(ps.getCompletionScore());
        vo.setJudgeScore(ps.getJudgeScore());
        vo.setTotalScore(ps.getTotalScore());
        vo.setIsSpecial(ps.getIsSpecial());
        return vo;
    }
}

