/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.question.provider;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.question.entity.TuPaper;
import cn.smarthse.radiationTraining.modules.question.param.ExamRecordsSearchParam;
import cn.smarthse.radiationTraining.modules.question.param.StartExamParam;
import cn.smarthse.radiationTraining.modules.question.param.SubmitExamParam;
import cn.smarthse.radiationTraining.modules.question.provider.ITuPaperProviderService;
import cn.smarthse.radiationTraining.modules.question.service.ITuPaperService;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperDataVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperResultVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamRecordVo;
import java.util.Collection;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.util.CollectionUtils;

@DubboService
public class TuPaperProviderServiceImpl
implements ITuPaperProviderService {
    private final ITuPaperService paperService;

    public String getExamProgressByTrainingId(Long trainingId) {
        return this.paperService.getExamProgressByTrainingId(trainingId);
    }

    public LayuiGridData<ExamRecordVo> getExamRecords(ExamRecordsSearchParam param) {
        return this.paperService.getExamRecords(param);
    }

    public ExamPaperResultVo getCourseExamDetail(Long id) {
        return this.paperService.getCourseExamDetail(id);
    }

    public ExamPaperDataVo getExamQuestions(StartExamParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"tid", "enrollDetailId"});
        if (param.getTrainTarget() == 0 && CollectionUtils.isEmpty((Collection)param.getIndustryCodes())) {
            throw new ServiceException("\u5fc5\u8981\u53c2\u6570[\u884c\u4e1a]\u7f3a\u5931\uff01");
        }
        if (param.getTrainTarget() != 0 && CollectionUtils.isEmpty((Collection)param.getPersonTypeCodes())) {
            throw new ServiceException("\u5fc5\u8981\u53c2\u6570[\u4eba\u5458\u7c7b\u578b]\u7f3a\u5931\uff01");
        }
        if (param.getTrainTarget() != null && (param.getTrainTarget() == 0 || param.getTrainTarget() == 21 || param.getTrainTarget() == 22)) {
            return this.paperService.getExamQuestions(param);
        }
        return this.paperService.getExamQuestionsForOrig(param);
    }

    public long getExamCoursePassCount(Long tuCourseId) {
        return this.paperService.getExamCoursePassCount(tuCourseId);
    }

    public long getExamCourseCount(Long tuCourseId) {
        return this.paperService.getExamCourseCount(tuCourseId);
    }

    public ExamPaperDataVo getReExamQuestions(StartExamParam param) {
        FieldCheckUtils.checkEmptyFields((Object)param, (String[])new String[]{"tid", "enrollDetailId", "paperStructureId"});
        return this.paperService.getReExamQuestions(param);
    }

    public ExamPaperResultVo submitExam(SubmitExamParam param) {
        return this.paperService.submitExam(param);
    }

    public Integer getTrainingAverageScore(Long uid, Long enrollDetailId) {
        return this.paperService.getTrainingAverageScore(uid, enrollDetailId);
    }

    public int getExamPassNumNoRepeat(Long enrollDetailId, Integer trainMode) {
        return this.paperService.getExamPassNumNoRepeat(enrollDetailId, trainMode);
    }

    public Integer checkForAdequacy(List<String> workTypes, Long paperStructId) {
        return this.paperService.checkForAdequacy(workTypes, paperStructId);
    }

    public void setResetByTuCourseId(List<Long> tuCourseIdList) {
        this.paperService.setResetByTuCourseId(tuCourseIdList);
    }

    public void setResetByDetailId(List<Long> tuEnrollDetailIdList) {
        this.paperService.setResetByDetailId(tuEnrollDetailIdList);
    }

    public void delTuPaperAndQuestion(Long tuEnrollDetailId) {
        this.paperService.delTuPaperAndQuestion(tuEnrollDetailId);
    }

    public void delTuPaperAndQuestionBatch(List<Long> tuEnrollDetailIds) {
        this.paperService.delTuPaperAndQuestionBatch(tuEnrollDetailIds);
    }

    public void setIsValidById(Boolean isValid, List<Long> ids) {
        this.paperService.setIsValidById(isValid, ids);
    }

    public List<TuPaper> getDeletedDataByDetailId(Long enrollDetailId) {
        return this.paperService.getDeletedDataByDetailId(enrollDetailId);
    }

    @Generated
    public TuPaperProviderServiceImpl(ITuPaperService paperService) {
        this.paperService = paperService;
    }
}

