/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.question.provider;

import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.question.converter.QuestionConverter;
import cn.smarthse.radiationTraining.modules.question.param.QuestionSearchParam;
import cn.smarthse.radiationTraining.modules.question.param.QuestionSetBatchParam;
import cn.smarthse.radiationTraining.modules.question.param.importQuestion.ImportQuestionData;
import cn.smarthse.radiationTraining.modules.question.provider.IQuestionProviderService;
import cn.smarthse.radiationTraining.modules.question.service.IQuestionRelationService;
import cn.smarthse.radiationTraining.modules.question.service.IQuestionService;
import cn.smarthse.radiationTraining.modules.question.vo.QuestionVo;
import cn.smarthse.radiationTraining.modules.question.vo.SpecialQuestionStatisticsVo;
import java.util.Collection;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@DubboService
public class QuestionProviderServiceImpl
implements IQuestionProviderService {
    private final IQuestionService questionService;
    @Autowired
    private IQuestionRelationService questionRelationService;
    private final QuestionConverter questionConverter;

    public LayuiGridData<QuestionVo> getQuestionList(QuestionSearchParam param) {
        return this.questionService.getQuestionPageList(param);
    }

    public QuestionVo getQuestionDetailById(Long questionId) {
        return this.questionService.getQuestionDetailById(questionId);
    }

    public void addQuestion(QuestionVo question) {
        FieldCheckUtils.checkEmptyFields((Object)question, (String[])new String[]{"status", "questionType", "stem", "answer", "analysis"});
        this.questionService.addQuestion(question);
    }

    public void updateQuestion(QuestionVo question) {
        FieldCheckUtils.checkEmptyFields((Object)question, (String[])new String[]{"id"});
        this.questionService.updateQuestion(question);
    }

    @Transactional
    public void deleteBatch(IdsParam ids) {
        List idList = ids.getIdList();
        if (CollectionUtils.isEmpty((Collection)idList)) {
            throw new ServiceException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        this.questionService.removeQuestionBatch(ids);
    }

    public List<String> importQuestion(List<ImportQuestionData> list) {
        if (CollectionUtils.isEmpty(list)) {
            throw new ServiceException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        return this.questionService.importQuestion(list);
    }

    public void setBatch(QuestionSetBatchParam param) {
        this.questionService.setBatch(param);
    }

    public SpecialQuestionStatisticsVo getSpecialQuestionNum(String code, Integer type) {
        return this.questionRelationService.getSpecialQuestionNum(code, type);
    }

    public List<String> checkImportDataForHSE(List<ImportQuestionData> dataList) {
        if (CollectionUtils.isEmpty(dataList)) {
            throw new ServiceException("\u5bfc\u5165\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        List list = this.questionConverter.toQuestionInfoList(dataList);
        return this.questionService.checkImportData(list);
    }

    @Generated
    public QuestionProviderServiceImpl(IQuestionService questionService, QuestionConverter questionConverter) {
        this.questionService = questionService;
        this.questionConverter = questionConverter;
    }
}

