/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.radiationTraining.modules.question.provider;

import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.core.framework.utils.FieldCheckUtils;
import cn.smarthse.radiationTraining.modules.question.entity.PaperStructure;
import cn.smarthse.radiationTraining.modules.question.param.PaperStructureParam;
import cn.smarthse.radiationTraining.modules.question.param.PaperStructureSearchParam;
import cn.smarthse.radiationTraining.modules.question.provider.IPaperStructureProviderService;
import cn.smarthse.radiationTraining.modules.question.service.IPaperStructureService;
import cn.smarthse.radiationTraining.modules.question.vo.PaperStructureVo;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.smarthse.radiationTraining.exception.ServiceException;
import lombok.Generated;
import org.apache.dubbo.config.annotation.DubboService;
import org.springframework.util.CollectionUtils;

@DubboService
public class PaperStructureProviderServiceImpl
implements IPaperStructureProviderService {
    private final IPaperStructureService paperStructureService;

    public LayuiGridData<PaperStructureVo> getPaperStructureList(PaperStructureSearchParam param) {
        return this.paperStructureService.getPaperStructureList(param);
    }

    public PaperStructure getPaperStructureDetailById(Long id) {
        if (id == null) {
            throw new ServiceException("id \u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return (PaperStructure)this.paperStructureService.getById(id);
    }

    public void addPaperStructure(PaperStructure paperStructure) {
        FieldCheckUtils.checkEmptyFields((Object)paperStructure, (String[])new String[]{"structName"});
        this.paperStructureService.save(paperStructure);
    }

    public void updatePaperStructure(PaperStructure paperStructure) {
        FieldCheckUtils.checkEmptyFields((Object)paperStructure, (String[])new String[]{"id"});
        this.paperStructureService.updateById(paperStructure);
    }

    public boolean updateStatus(Long id, Integer status) {
        if (id == null || status == null) {
            throw new ServiceException("\u5fc5\u8981\u53c2\u6570\u7f3a\u5931\uff01");
        }
        boolean isSelected = this.paperStructureService.isSelectedInCourseItem(id);
        if (isSelected) {
            throw new ServiceException("\u8bd5\u5377\u7ed3\u6784\u5df2\u88ab\u8bfe\u7a0b\u9009\u4e2d\uff01\u65e0\u6cd5\u7981\u7528\uff01");
        }
        boolean isSelectedByTrain = this.paperStructureService.isSelectedInTrain(id);
        if (isSelectedByTrain) {
            throw new ServiceException("\u8bd5\u5377\u7ed3\u6784\u5df2\u88ab\u4e0a\u67b6\u57f9\u8bad\u9009\u4e2d\uff01\u65e0\u6cd5\u7981\u7528\uff01");
        }
        return this.paperStructureService.updateStatus(id, status);
    }

    public boolean updateIsSpecial(PaperStructureParam param) {
        if (param.getId() == null || param.getIsSpecial() == null) {
            throw new ServiceException("\u5fc5\u8981\u53c2\u6570\u7f3a\u5931\uff01");
        }
        return this.paperStructureService.updateIsSpecial(param);
    }

    public void deleteBatch(IdsParam ids) {
        List idList = ids.getIdList();
        if (CollectionUtils.isEmpty((Collection)idList)) {
            throw new ServiceException("\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u6761\u6570\u636e\uff01");
        }
        idList.stream().forEach(id -> {
            boolean isSelected = this.paperStructureService.isSelectedInCourseItem((Long)id);
            if (isSelected) {
                throw new ServiceException("\u8bd5\u5377\u7ed3\u6784\u5df2\u88ab\u8bfe\u7a0b\u9009\u4e2d\uff01\u65e0\u6cd5\u5220\u9664\uff01");
            }
            boolean isSelectedByTrain = this.paperStructureService.isSelectedInTrain((Long)id);
            if (isSelectedByTrain) {
                throw new ServiceException("\u8bd5\u5377\u7ed3\u6784\u5df2\u88ab\u4e0a\u67b6\u57f9\u8bad\u9009\u4e2d\uff01\u65e0\u6cd5\u7981\u7528\uff01");
            }
            this.paperStructureService.removeById((Serializable)id);
        });
    }

    public List<PaperStructure> selectBatchIds(List<Long> ids) {
        return this.paperStructureService.selectBatchIds(ids);
    }

    public PaperStructureVo getVoById(Long id) {
        return this.paperStructureService.getVoById(id);
    }

    @Generated
    public PaperStructureProviderServiceImpl(IPaperStructureService paperStructureService) {
        this.paperStructureService = paperStructureService;
    }
}

