package cn.smarthse.radiationTraining.modules.question.vo;

import cn.smarthse.radiationTraining.modules.question.entity.QuestionRelation;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * <p>
 * 试题库 vo
 * </p>
 *
 * @author wuxq
 * @since 2022-03-10
 */
public @Data
class QuestionVo implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty(value = "id")
    private Long id;

    //@ApiModelProperty(value = "适用工作类别id", hidden = true)
    private String suitableJobTypes;
    //@ApiModelProperty(value = "适用危害因素code")
    private String suitableFactorNos;
    //@ApiModelProperty(value = "适用人员类别（code英文 , 分隔）")
    private String suitablePersonTypes;
    //@ApiModelProperty(value = "适用行业类别（code英文 , 分隔）")
    private String suitableIndustryCodes;
    //@ApiModelProperty(value = "适用课程（code英文 , 分隔）")
    private String suitableCourseIds;

    //@ApiModelProperty(value = "适用工作类别名称", hidden = true)
    private String suitableJobTypesStr;
    //@ApiModelProperty(value = "适用危害因素名称")
    private String factorNoNames;
    //@ApiModelProperty(value = "适用人员类别名称")
    private String personTypeNames;
    //@ApiModelProperty(value = "适用行业类别名称")
    private String industryCodeNames;
    //@ApiModelProperty(value = "适用课程名称")
    private String suitableCourseNames;

    //@ApiModelProperty(value = "状态（0：已禁用(不用的试题,过时的试题)；1：未入库(草稿状态)；2：已入库；）")
    private Integer status;

    //@ApiModelProperty(value = "试题类别（1-单选题；2-多选题；3-填空题；4-判断题）")
    private Integer questionType;

    //@ApiModelProperty(value = "题干")
    private String stem;

    //@ApiModelProperty(value = "选项A")
    private String optionA;

    //@ApiModelProperty(value = "选项B")
    private String optionB;

    //@ApiModelProperty(value = "选项C")
    private String optionC;

    //@ApiModelProperty(value = "选项D")
    private String optionD;

    //@ApiModelProperty(value = "选项E")
    private String optionE;

    //@ApiModelProperty(value = "选项F")
    private String optionF;

    //@ApiModelProperty(value = "选项G")
    private String optionG;

    //@ApiModelProperty(value = "正确答案（多选答案，如AB）")
    private String answer;

    //@ApiModelProperty(value = "解析")
    private String analysis;

    //@ApiModelProperty(value = "更新时间")
    private Date updateDate;

    //@ApiModelProperty(value = "试题对应关系", required = true)
    private List<QuestionRelation> questionRelationList;

    //@ApiModelProperty(value = "创建人id",hidden = true)
    private Long createBy;

    //@ApiModelProperty(value = "创建人")
    private String createName;

    //@ApiModelProperty(value = "更新人id",hidden = true)
    private Long updateBy;

    //@ApiModelProperty(value = "更新人")
    private String updateName;

    //@ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser;

}
