package cn.smarthse.radiationTraining.modules.question.vo;

import cn.smarthse.radiationTraining.modules.question.enums.ComposePaperTypeEnum;
import lombok.Data;

import java.io.Serializable;


/**
 * <p>
 * 试卷结构 vo
 * </p>
 *
 * @author wuxq
 * @since 2022-03-10
 */
public @Data
class PaperStructureVo implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("id")
    private Long id;

    //@ApiModelProperty("试卷结构名称")
    private String structName;

    //@ApiModelProperty("组卷方式（默认1：自动；2：手动）")
    private String way;

    //@ApiModelProperty("试题量")
    private String questionsNumStr;

    //@ApiModelProperty(value = "单选题数")
    private Integer singleNum = 0;

    //@ApiModelProperty(value = "多选题数")
    private Integer multipleNum = 0;

    //@ApiModelProperty(value = "填空题数")
    private Integer completionNum = 0;

    //@ApiModelProperty(value = "判断题数")
    private Integer judgeNum = 0;

    //@ApiModelProperty(value = "每个单选题分数")
    private Integer singleScore;

    //@ApiModelProperty(value = "每个多选题分数")
    private Integer multipleScore;

    //@ApiModelProperty(value = "每个填空题分数")
    private Integer completionScore;

    //@ApiModelProperty(value = "每个判断题分数")
    private Integer judgeScore;

    //@ApiModelProperty("总分")
    private Integer totalScore;

    //@ApiModelProperty("状态（0：禁用；1：启用）")
    private Integer status;
    /**
     * 是否显示（0-否；1-是）
     * 显示的试卷结构可以被课程选中
     */
    //@ApiModelProperty(value = "是否显示（0-否；1-是）")
    private Integer isSpecial;

    private Long createBy;

    public String getWay() {
        if (way == null) return "";
        return ComposePaperTypeEnum.getName(Integer.valueOf(way));
    }


    public String getWayCode() {
        return this.way;
    }

    public String getQuestionsNumStr() {
        StringBuilder result = new StringBuilder("");
        if (singleNum > 0)
            result.append("单选：").append(singleNum).append("；");
        if (multipleNum > 0)
            result.append("多选：").append(multipleNum).append("；");
        if (completionNum > 0)
            result.append("填空：").append(completionNum).append("；");
        if (judgeNum > 0)
            result.append("判断：").append(judgeNum).append("；");
        return result.toString();
    }
}
