package cn.smarthse.radiationTraining.modules.question.param;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 开始考试，获取试题 参数对象
 *
 * @author wuxq
 * @date
 */
@Data
public class StartExamParam implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty(value = "用户id", hidden = true)
    private Long userId;

    //@ApiModelProperty(value = "培训id")
    private Long tid;

    //@ApiModelProperty("培训对象(0-用人单位；11-技术服务机构；12-职业健康体检机构；13-技术服务、职业健康体检机构)")
    private Integer trainTarget;

    //@ApiModelProperty(value = "培训模式(0-专业; 1-精准;2-服务机构)")
    private Integer trainMode;

    //@ApiModelProperty(value = "考试方式(0-分别考试；1-集中考试)", required = true)
    private Integer testMode;

    //@ApiModelProperty(value = "培训报名详情id", required = true)
    private Long enrollDetailId;

    //@ApiModelProperty(value = "考试课程id", required = true)
    private Long tuCourseId;

    //@ApiModelProperty(value = "课程id", hidden = true)
    private Long courseId;

    //@ApiModelProperty(value = "课程id集合(用于统一考试)", hidden = true)
    private List<String> courseIdList;

    //@ApiModelProperty(value = "考试课程试卷结构id", hidden = true)
    private Long paperStructureId;

    //@ApiModelProperty(value = "考试课程适用工作类别", hidden = true)
    private List<String> workTypes;

    //@ApiModelProperty(value = "考试课程-行业", hidden = true)
    private List<String> industryCodes;

    //@ApiModelProperty(value = "考试课程-危害因素", hidden = true)
    private List<String> riskFactorCodes;

    //@ApiModelProperty(value = "考试课程-人员类型", hidden = true)
    private List<String> personTypeCodes;

    //@ApiModelProperty(value = "试卷使用方式(0-随机分配;1-学员共用)", hidden = true)
    private Integer testPaperUsage;

    //@ApiModelProperty(value = "重考设置(0-原题重考；1-原题打乱；2-重组试卷)", hidden = true)
    private Integer retestSetting;

    //@ApiModelProperty(value = "是否重新考试（默认为否：0；是：1）", required = true)
    private Boolean reTest = false;

    //@ApiModelProperty(value = "考试及格线", hidden = true)
    private Integer passScore;

    /**
     * 组卷方式（默认1：自动；2：手动）
     */
    //@ApiModelProperty(value = "组卷方式（默认1：自动；2：手动）", hidden = true)
    private Long way;
    /**
     * 单选题数
     */
    //@ApiModelProperty(value = "单选题数", hidden = true)
    private Integer singleNum;
    /**
     * 多选题数
     */
    //@ApiModelProperty(value = "多选题数", hidden = true)
    private Integer multipleNum;
    /**
     * 填空题数
     */
    //@ApiModelProperty(value = "填空题数", hidden = true)
    private Integer completionNum;
    /**
     * 判断题数
     */
    //@ApiModelProperty(value = "判断题数", hidden = true)
    private Integer judgeNum;
    /**
     * 每个单选题分数
     */
    //@ApiModelProperty(value = "每个单选题分数", hidden = true)
    private Integer singleScore;
    /**
     * 每个多选题分数
     */
    //@ApiModelProperty(value = "每个多选题分数", hidden = true)
    private Integer multipleScore;
    /**
     * 每个填空题分数
     */
    //@ApiModelProperty(value = "每个填空题分数", hidden = true)
    private Integer completionScore;
    /**
     * 每个判断题分数
     */
    //@ApiModelProperty(value = "每个判断题分数", hidden = true)
    private Integer judgeScore;
    /**
     * 总分
     */
    //@ApiModelProperty(value = "总分", hidden = true)
    private Integer totalScore;

}
