package cn.smarthse.radiationTraining.modules.question.param;

import cn.smarthse.radiationTraining.modules.question.entity.QuestionRelation;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * 试题批量设置 参数对象
 *
 * @author wuxq
 * @date
 */
@Data
@NoArgsConstructor
public class QuestionSetBatchParam implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("试题ids")
    private List<Long> ids;

    //@ApiModelProperty(value = "适用危害因素（code英文 , 分隔）")
    private String suitableFactorNos;
    //@ApiModelProperty(value = "适用行业类别（code英文 , 分隔）")
    private String suitableIndustryCodes;
    //@ApiModelProperty(value = "适用课程（code英文 , 分隔）")
    private String suitableCourseIds;

    //@ApiModelProperty(value = "适用危害因素名称（中文逗号分隔）")
    private String factorNoNames;
    //@ApiModelProperty(value = "适用行业类别名称（中文逗号分隔）")
    private String industryCodeNames;
    //@ApiModelProperty(value = "适用课程名称（中文逗号分隔）")
    private String suitableCourseNames;

    //@ApiModelProperty(value = "试题对应关系", required = true)
    private List<QuestionRelation> questionRelationList;


    //@ApiModelProperty(value = "关系类型(1-行业; 2-危害因素; 3-人员类型;4-课程)")
    private String relationType;

    //@ApiModelProperty(value = "状态（0：已禁用；1：未入库(草稿状态)；2：已入库；）")
    private Integer status;


    //@ApiModelProperty(value = "更新人id",hidden = true)
    private Long updateBy;

    //@ApiModelProperty(value = "更新人",hidden = true)
    private String updateName;

    //@ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser;

}
