package cn.smarthse.radiationTraining.modules.question.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * <p>
 * 考生试卷试题
 * </p>
 *
 * @author wuxq
 * @since 2022-03-10
 */
//@ApiModel(value = "考生试卷试题")
@TableName("tu_paper_question")
public @Data class TuPaperQuestion implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    //@ApiModelProperty(value = "ID")
    private Long id;
    /**
     * 用户试卷id（tu_paper_id）
     */
    //@ApiModelProperty(value = "用户试卷id（tu_paper_id）")
    private Long tuPaperId;
    /**
     * 用户id
     */
    private Long userId;
    /**
     * 试题id
     */
    //@ApiModelProperty(value = "试题id")
    private Long questionId;
    /**
     * 试题类别（1-单选题；2-多选题；3-填空题；4-判断题）
     */
    //@ApiModelProperty(value = "试题类别（1-单选题；2-多选题；3-填空题；4-判断题）")
    private Integer questionType;
    /**
     * 题干（冗余）
     */
    //@ApiModelProperty(value = "题干（冗余）")
    private String stem;
    /**
     * 选项A（冗余）
     */
    //@ApiModelProperty(value = "选项A（冗余）")
    private String optionA;
    /**
     * 选项B（冗余）
     */
    //@ApiModelProperty(value = "选项B（冗余）")
    private String optionB;
    /**
     * 选项C（冗余）
     */
    //@ApiModelProperty(value = "选项C（冗余）")
    private String optionC;
    /**
     * 选项D（冗余）
     */
    //@ApiModelProperty(value = "选项D（冗余）")
    private String optionD;
    /**
     * 选项E（冗余）
     */
    //@ApiModelProperty(value = "选项E（冗余）")
    private String optionE;
    //@ApiModelProperty(value = "选项F")
    private String optionF;
    //@ApiModelProperty(value = "选项G")
    private String optionG;
    /**
     * 正确答案（冗余）
     */
    //@ApiModelProperty(value = "正确答案（冗余）")
    private String answer;
    /**
     * 解析（冗余）
     */
    //@ApiModelProperty(value = "解析（冗余）")
    private String analysis;
    /**
     * 用户作答
     */
    //@ApiModelProperty(value = "用户作答")
    private String userAnswer;
    /**
     * 判定结果（1-正确，0-错误）
     */
    //@ApiModelProperty(value = "判定结果（1-正确，0-错误）")
    private Integer judgeResult;
    /**
     * 单题得分
     */
    //@ApiModelProperty(value = "单题得分")
    private Integer score = 0;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 是否有效(0-无效；1-有效)
     */
    private Boolean isValid;


}
