package cn.smarthse.radiationTraining.modules.question.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;


/**
 * <p>
 * 考生试卷
 * </p>
 *
 * @author wuxq
 * @since 2022-03-10
 */
@Accessors(chain = true)
@TableName("tu_paper")
public @Data class TuPaper implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * ID
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;
    /**
     * 用户报名id
     */
    private Long enrollDetailId;
    /**
     * 培训id
     */
    private Long trainingId;
    /**
     * 报名课程id
     */
    private Long tuCourseId;
    /**
     * 课程id
     */
    private Long courseId;
    /**
     * 用户id
     */
    private Long userId;
    /**
     * 及格线
     */
    private Integer passScore;
    /**
     * 得分
     */
    private Integer score;
    /**
     * 在线考试方式(0-分别考试；1-统一考试)
     */
    private Integer testMode;
    /**
     * 0-未考试；1-未通过；2-已通过
     */
    private Integer result;
    /**
     * 考试用时（秒）
     */
    private Integer timeCost;
    /**
     * 是否为被重置的数据(0-否；1-是)
     */
    private Integer isReset;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 创建人
     */
    private Long createBy;
    /**
     * 更新人
     */
    private Long updateBy;
    /**
     * 是否有效(0-无效；1-有效)
     */
    private Boolean isValid;

    /**
     * 是否新创建试卷(用于获取试题，初始化试卷时使用)
     */
    @TableField(exist = false)
    private Boolean isNewPaper = true;
}
