package cn.smarthse.radiationTraining.modules.question.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;


/**
 * <p>
 * 试题-关系
 * </p>
 *
 * @author chuhy
 * @since 2022-8-17
 */
@Accessors(chain = true)
@TableName("question_relation")
public @Data class QuestionRelation implements Serializable {

    private static final long serialVersionUID = 321516782164L;

    //@ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 试题id
     */
    //@ApiModelProperty(value = "试题id")
    private Long questionId;

    /**
     * 关联数据(id或者code)
     */
    //@ApiModelProperty(value = "关联数据(id或者code)", required = true)
    private String relationCode;

    /**
     * 关系对应名称
     */
    //@ApiModelProperty(value = "关系对应名称", required = true)
    private String relationName;

    /**
     * 关系类型(1-行业; 2-危害因素; 3-人员类型)
     */
    //@ApiModelProperty(value = "关系类型(1-行业; 2-危害因素; 3-人员类型;4-课程)", required = true)
    private String relationType;

    //@ApiModelProperty(hidden = true)
    private Long createBy;

    //@ApiModelProperty(hidden = true)
    private Date createTime;

    //@ApiModelProperty(hidden = true)
    private Long updateBy;

    //@ApiModelProperty(hidden = true)
    private Date updateTime;

    //@ApiModelProperty(hidden = true)
    private Boolean isValid;


}
