package cn.smarthse.radiationTraining.modules.question.vo;

import cn.smarthse.radiationTraining.modules.question.entity.TuPaperQuestion;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;
import java.util.List;


/**
 * <p>
 * 考试试卷结算数据 vo
 * </p>
 *
 * @author wuxq
 * @since 2022-03-23
 */
@Accessors(chain = true)
@Data
public class ExamPaperResultVo implements Serializable {

    private static final long serialVersionUID = 2496954082181928649L;

    @ApiModelProperty(value = "试卷id")
    private Long tuPaperId;

    @ApiModelProperty(value = "课程名称")
    private String courseName;

    @ApiModelProperty(value = "课程考试通过次数", hidden = true)
    private int passTimes;

    @ApiModelProperty(value = "考试时间")
    private Date examTime;

    @ApiModelProperty(value = "答题时间(秒)")
    private Integer timeCost;

    @ApiModelProperty(value = "答题时间(秒)")
    private String timeCostStr;

    @ApiModelProperty(value = "得分", hidden = true)
    private Integer score;

    @ApiModelProperty(value = "考试结果", hidden = true)
    private String result;

    @ApiModelProperty(value = "在线考试方式(0-分别考试；1-集中考试)", hidden = true)
    private Integer testMode;

    @ApiModelProperty(value = "考试结果值:1-未通过，2-通过", hidden = true)
    private Integer resultValue;

    @ApiModelProperty(value = "试题集合")
    private List<TuPaperQuestion> questions;

}
