package cn.smarthse.radiationTraining.modules.question.provider;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.question.entity.TuPaper;
import cn.smarthse.radiationTraining.modules.question.entity.TuPaperQuestion;
import cn.smarthse.radiationTraining.modules.question.param.ExamRecordsSearchParam;
import cn.smarthse.radiationTraining.modules.question.param.StartExamParam;
import cn.smarthse.radiationTraining.modules.question.param.SubmitExamParam;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperDataVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperResultVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamRecordVo;

import java.util.List;

/**
 * @ClassName IQuestionProviderService
 * @Description 对外 试卷接口
 * @Author Wuxq
 * @Date 2022/3/10
 */
public interface ITuPaperQuestProviderService {
    /**
     * @description 设置is_valid 的字段值
     * @param isValid is_valid 字段值
     * @param tuPaperIds TuPaper 的id
     * @return void
     * @author chenliang
     * @date 2022/11/14 09:33:55
     */
    void setIsValidByTuPaperId(Boolean isValid, List<Long> tuPaperIds);

    /**
     * @description 根据被试卷id获取考试信息列表
     * @param tuPaperId 试卷id
     * @return java.util.List<cn.smarthse.radiationTraining.modules.question.entity.TuPaper>
     * @author chenliang
     * @date 2022/11/14 09:44:22
     */
    List<TuPaperQuestion> getDeletedDataByTuPaperId(Long tuPaperId);
}
