package cn.smarthse.radiationTraining.modules.question.provider;

import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.question.entity.Question;
import cn.smarthse.radiationTraining.modules.question.param.QuestionSearchParam;
import cn.smarthse.radiationTraining.modules.question.param.QuestionSetBatchParam;
import cn.smarthse.radiationTraining.modules.question.param.importQuestion.ImportQuestionData;
import cn.smarthse.radiationTraining.modules.question.param.importQuestion.ImportQuestionErrData;
import cn.smarthse.radiationTraining.modules.question.vo.QuestionVo;
import cn.smarthse.radiationTraining.modules.question.vo.SpecialQuestionStatisticsVo;

import java.util.List;

/**
 * @ClassName IQuestionProviderService
 * @Description 对外试题接口
 * @Author Wuxq
 * @Date 2022/3/10
 */
public interface IQuestionProviderService {

    /**
     * 方法描述:  获取试题管理列表
     *
     * @param   param 查询参数对象
     * @return  LayuiGridData<QuestionVo>
     * @author  wuxq
     * @date    2022/3/11
     */
    LayuiGridData<QuestionVo> getQuestionList(QuestionSearchParam param);

    /**
     * 方法描述:  试题详情
     *
     * @param   questionId 试题id
     * @return  Question
     * @author  wuxq
     * @date    2022/3/11
     */
    QuestionVo getQuestionDetailById(Long questionId);

    /**
     * 方法描述:  新增试题
     *
     * @param   question 试题对象
     * @return  void
     * @author  wuxq
     * @date    2022/3/11
     */
    void addQuestion(QuestionVo question);

    /**
     * 方法描述:  更新试题
     *
     * @param   question 试题对象
     * @return  void
     * @author  wuxq
     * @date    2022/3/11
     */
    void updateQuestion(QuestionVo question);

    /**
     * 方法描述:  批量删除
     *
     * @param   ids IdsParam
     * @return  void
     * @author  wuxq
     * @date    2022/3/11
     */
    void deleteBatch(IdsParam ids);

    /**
     * 方法描述:  导入试题
     *
     * @param   list 试题数据
     * @return  void
     * @author  wuxq
     * @date    2022/3/16
     */
    List<String> importQuestion(List<ImportQuestionData> list);

    /**
     * 方法描述:  批量设置试题
     *
     * @param   param QuestionSetBatchParam
     * @return  void
     * @author  wuxq
     * @date    2022/8/17
     */
    void setBatch(QuestionSetBatchParam param);

    /**
     * @description 获取专用题库数量
     * @param code
     * @return int
     * @author chenliang
     * @date 2022/8/18 13:51:48
     */
    SpecialQuestionStatisticsVo getSpecialQuestionNum(String code,Integer type);


    List<String> checkImportDataForHSE(List<ImportQuestionData> dataList);
}
