package cn.smarthse.radiationTraining.modules.question.provider;

import cn.smarthse.radiationTraining.core.framework.model.IdsParam;
import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.question.entity.PaperStructure;
import cn.smarthse.radiationTraining.modules.question.param.PaperStructureParam;
import cn.smarthse.radiationTraining.modules.question.param.PaperStructureSearchParam;
import cn.smarthse.radiationTraining.modules.question.vo.PaperStructureVo;

import java.util.List;

/**
 * @ClassName IQuestionProviderService
 * @Description 对外 试卷结构接口
 * @Author Wuxq
 * @Date 2022/3/10
 */
public interface IPaperStructureProviderService {

    /**
     * 方法描述:  获取试卷结构列表
     *
     * @param param 查询参数对象
     * @return LayuiGridData<PaperStructureVo>
     * @author wuxq
     * @date 2022/3/11
     */
    LayuiGridData<PaperStructureVo> getPaperStructureList(PaperStructureSearchParam param);

    /**
     * 方法描述:  获取试卷结构详情
     *
     * @param id 试卷结构id
     * @return PaperStructure
     * @author wuxq
     * @date 2022/3/11
     */
    PaperStructure getPaperStructureDetailById(Long id);

    /**
     * 方法描述:  添加
     *
     * @param paperStructure 参数对象
     * @return void
     * @author wuxq
     * @date 2022/3/14
     */
    void addPaperStructure(PaperStructure paperStructure);

    /**
     * 方法描述:  更新
     *
     * @param paperStructure 参数对象
     * @return void
     * @author wuxq
     * @date 2022/3/14
     */
    void updatePaperStructure(PaperStructure paperStructure);

    /**
     * 方法描述:
     *
     * @param id     试卷结构id
     * @param status 状态（0：禁用；1：启用）
     * @return Integer
     * @author wuxq
     * @date 2022/3/14
     */
    boolean updateStatus(Long id, Integer status);

    boolean updateIsSpecial(PaperStructureParam param);

    /**
     * 方法描述:  删除、批量删除
     *
     * @param ids id
     * @return void
     * @author wuxq
     * @date 2022/3/14
     */
    void deleteBatch(IdsParam ids);

    /**
     * 方法描述:  根据ids批量查询
     *
     * @param   ids ids
     * @return  List<PaperStructure>
     * @author  wuxq
     * @date    2022/5/31
     */
    List<PaperStructure> selectBatchIds(List<Long> ids);


    /**
     * @description 获取试卷结构
     * @param id
     * @return PaperStructureVo
     * @author chenliang
     * @date 2022/10/20 08:38:42
     */
     PaperStructureVo getVoById(Long id);

}
