package cn.smarthse.radiationTraining.modules.question.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 考试结果 枚举
 *
 * @author wuxq
 * @date 2022/3/14
 */
@AllArgsConstructor
@Getter
public enum ExamResultEnum {

    NO_PASSED(1, "未通过"),

    PASSED(2, "通过");

    private Integer value;

    private String name;

    public static String getNameByValue(Integer resultValue) {
        for (ExamResultEnum resultEnum : ExamResultEnum.values()) {
            if (resultEnum.getValue().equals(resultValue)) {
                return resultEnum.getName();
            }
        }
        return null;
    }
}
