package cn.smarthse.radiationTraining.modules.question.converter;

import cn.smarthse.radiationTraining.modules.question.entity.Question;
import cn.smarthse.radiationTraining.modules.question.entity.TuPaperQuestion;
import cn.smarthse.radiationTraining.modules.question.vo.ExamQuestionsDataVo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 *  TuPaperQuestion 对象转换器
 *
 * @author wuxq
 * @date 2022/3/16
 */
@Mapper(componentModel = "spring")
public interface TuPaperQuestionConverter {

    TuPaperQuestionConverter INSTANCE = Mappers.getMapper(TuPaperQuestionConverter.class);

    /**
     * 方法描述:  TuPaperQuestion to ExamQuestionsDataVo
     *
     * @param   examQuestionsDataVo
     * @return  Question
     * @author  wuxq
     * @date    2022/3/24
     */
    @Mapping(target = "analysis", ignore = true)
    @Mapping(target = "userAnswer", ignore = true)
    ExamQuestionsDataVo toExamQuestionsDataVo(TuPaperQuestion tuPaperQuestion);

    /**
     * List<TuPaperQuestion> to List<ExamQuestionsDataVo>
     * @author wuxq
     * @date 2022/2/24 13:43
     * @param list
     * @return {@link ExamQuestionsDataVo}
     */
    List<ExamQuestionsDataVo> toExamQuestionsDataVoList (List<TuPaperQuestion> list);


    /**
     * 方法描述:  Question to TuPaperQuestion
     *
     * @param   question Question
     * @return  TuPaperQuestion
     * @author  wuxq
     * @date    2022/3/25
     */
    @Mapping(target = "id", ignore = true)
    @Mapping(target = "createBy", ignore = true)
    @Mapping(target = "updateBy", ignore = true)
    @Mapping(target = "isValid", ignore = true)
    @Mapping(target = "questionId", source = "id")
    TuPaperQuestion toTuPaperQuestion(Question question);

    /**
     * 方法描述:  List<Question> to List<TuPaperQuestion>
     *
     * @param   list Question
     * @return  List<TuPaperQuestion>
     * @author  wuxq
     * @date    2022/3/25
     */
    List<TuPaperQuestion> toTuPaperQuestionList (List<Question> list);
}