package cn.smarthse.radiationTraining.modules.question.converter;

import cn.smarthse.radiationTraining.modules.question.entity.Question;
import cn.smarthse.radiationTraining.modules.question.entity.TuPaperQuestion;
import cn.smarthse.radiationTraining.modules.question.param.importQuestion.ImportQuestionData;
import cn.smarthse.radiationTraining.modules.question.vo.QuestionVo;
import org.mapstruct.Mapper;
import org.mapstruct.Mapping;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * Question 对象转换器
 *
 * @author wuxq
 * @date 2022/3/16
 */
@Mapper(componentModel = "spring")
public interface QuestionConverter {

    QuestionConverter INSTANCE = Mappers.getMapper(QuestionConverter.class);

    Question voToEntity(QuestionVo vo);

    /**
     * ImportQuestionData to Question
     *
     * @param importSingleQuestionData
     * @return {@link Question}
     * @author wuxq
     * @date 2022/2/24 13:43
     */
    Question toQuestion(ImportQuestionData importSingleQuestionData);

    /**
     * List<ImportQuestionData> to List<Question>
     *
     * @param list
     * @return {@link Question}
     * @author wuxq
     * @date 2022/2/24 13:43
     */
    List<Question> toQuestionInfoList(List<ImportQuestionData> list);

    /**
     * TuPaperQuestion to Question
     *
     * @param tuPaperQuestion
     * @return {@link Question}
     * @author wuxq
     * @date 2022/2/24 13:43
     */
    @Mapping(target = "id", source = "questionId")
    Question toQuestion(TuPaperQuestion tuPaperQuestion);

    /**
     * List<TuPaperQuestion> to List<Question>
     *
     * @param list
     * @return {@link Question}
     * @author wuxq
     * @date 2022/2/24 13:43
     */
    List<Question> toQuestionList(List<TuPaperQuestion> list);

    /**
     * 试题转 试卷试题
     * @author chuhy
     * @date 2024/1/19 13:22
     */
    @Mapping(target = "questionId", source = "id")
    TuPaperQuestion entity2PaperQuestion(Question entity);
    /**
     * 试题集合 转 试卷试题集合
     * @author chuhy
     * @date 2024/1/19 13:22
     */
    List<TuPaperQuestion> entityList2PaperQuestionList(List<Question> entity);

    QuestionVo entityToVo(Question entity);

    List<QuestionVo> entityListToVoList(List<Question> entity);
}