package cn.smarthse.radiationTraining.modules.question.provider;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.question.entity.TuPaper;
import cn.smarthse.radiationTraining.modules.question.param.ExamRecordsSearchParam;
import cn.smarthse.radiationTraining.modules.question.param.StartExamParam;
import cn.smarthse.radiationTraining.modules.question.param.SubmitExamParam;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperDataVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamPaperResultVo;
import cn.smarthse.radiationTraining.modules.question.vo.ExamRecordVo;

import java.util.List;

/**
 * @ClassName IQuestionProviderService
 * @Description 对外 试卷接口
 * @Author Wuxq
 * @Date 2022/3/10
 */
public interface ITuPaperProviderService {

    /**
     * 方法描述:  查询培训考试进度
     *
     * @param trainingId 培训id
     * @return String 已通过考试数/必过考试课程数，如 7/10
     * @author wuxq
     * @date 2022/3/22
     */
    String getExamProgressByTrainingId(Long trainingId);

    /**
     * 方法描述:  查询课程考试记录分页
     *
     * @param param 查询参数
     * @return LayuiGridData<ExamRecordVo>
     * @author wuxq
     * @date 2022/3/22
     */
    LayuiGridData<ExamRecordVo> getExamRecords(ExamRecordsSearchParam param);

    /**
     * 方法描述:  考试记录详情
     *
     * @param id tupaperId
     * @return ExamPaperResultVo
     * @author wuxq
     * @date 2022/4/8
     */
    ExamPaperResultVo getCourseExamDetail(Long id);

    /**
     * 方法描述:  获取试卷试题（生成试卷试题）
     * 该课程第一次考试生成试题 或者重考时重新生成试题，直接根据课程适用工作类别、试卷结构生成试题
     *
     * @param param 参数对象
     * @return ExamPaperDataVo
     * @author wuxq
     * @date 2022/3/23
     */
    ExamPaperDataVo getExamQuestions(StartExamParam param);

    /**
     * 方法描述:  统计某课程通过的考试数
     *
     * @param   tuCourseId 用户的课程id
     * @return  int
     * @author  wuxq
     * @date    2022/5/12
     */
    int getExamCoursePassCount(Long tuCourseId);

    /**
     * 统计某课程的考试次数
     * @param   tuCourseId 用户的课程id
     * @return  int
     * @author  chuhy
     */
    int getExamCourseCount(Long tuCourseId);

    /**
     * 方法描述:  重新考试获取试题
     *
     * @param param 参数对象
     * @return ExamPaperDataVo
     * @author wuxq
     * @date 2022/3/25
     */
    ExamPaperDataVo getReExamQuestions(StartExamParam param);

    /**
     * 方法描述:  考试提交结算
     *
     * @param param 参数对象
     * @return ExamPaperResultVo
     * @author wuxq
     * @date 2022/3/28
     */
    ExamPaperResultVo submitExam(SubmitExamParam param);

    /**
     * 方法描述:  计算培训考试平均成绩
     *
     * @param uid            用户id
     * @param enrollDetailId 培训报名详情id
     * @return null
     * @author wuxq
     * @date 2022/5/11
     */
    Integer getTrainingAverageScore(Long uid, Long enrollDetailId);

    /**
     * (分别考试)根据报名详情id，查已通过的考试数量（同样的课程多次通过不会累加）
     *
     * @param enrollDetailId 报名详情id
     * @return int 用户通过考试的数量（相同课程通过多次不会累加）
     * @author chuhy
     */
    int getExamPassNumNoRepeat(Long enrollDetailId,Integer trainMode);


    /**
     * 校验试卷结构对应的工作类别题目是否充足
     * @param workTypes
     * @param paperStructId
     * @return 0 充足 1单选题不足 2多选题不足 3填空题不足
     * @author chenliang
     */
    Integer checkForAdequacy(List<String> workTypes, Long paperStructId);


    /**
     * 将tuCourse对应的tupaper重置(分别考试)
     * @param tuCourseIdList 用户课程id集合
     * @author chuhy
     */
    void setResetByTuCourseId(List<Long> tuCourseIdList);

    /**
     * 将tuEnrollDetail对应的tuPaper重置(统一考试)
     * @param tuEnrollDetailIdList 用户课程id集合
     * @author chuhy
     */
    void setResetByDetailId(List<Long> tuEnrollDetailIdList);

    /**
     * 根据报名详情id删除对应的考试
     * @param tuEnrollDetailId 报名详情id
     * @author chuhy
     */
    void delTuPaperAndQuestion(Long tuEnrollDetailId);
    /**
     * 根据报名详情id删除对应的考试
     * @param tuEnrollDetailIds 报名详情id
     * @author chuhy
     */
    void delTuPaperAndQuestionBatch(List<Long> tuEnrollDetailIds);
    /**
     * @description 设置is_valid 的字段值
     * @param isValid is_valid 字段值
     * @param ids TuPaper 的id
     * @return void
     * @author chenliang
     * @date 2022/11/14 09:33:55
     */
    void setIsValidById(Boolean isValid, List<Long> ids);

    /**
     * @description 根据被删除的报名详情id获取考试信息列表
     * @param enrollDetailId 报名详情id
     * @return java.util.List<cn.smarthse.radiationTraining.modules.question.entity.TuPaper>
     * @author chenliang
     * @date 2022/11/14 09:44:22
     */
    List<TuPaper> getDeletedDataByDetailId(Long enrollDetailId);
}
