package cn.smarthse.radiationTraining.modules.question.param.importQuestion;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;


/**
 * <p>
 * 试题库
 * </p>
 *
 * @author wuxq
 * @since 2022-03-10
 */
@Data
public class ImportQuestionData implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 题干
     */
    @ExcelProperty(index = 0)
    private String stem;
    /**
     * 试题类别（1-单选题；2-多选题；3-填空题；4-判断题）
     */
    @ExcelProperty(index = 1)
    private String questionTypeStr;
    private Integer questionType;
    /**
     * 选项A
     */
    @ExcelProperty(index = 2)
    private String optionA;
    /**
     * 选项B
     */
    @ExcelProperty(index = 3)
    private String optionB;
    /**
     * 选项C
     */
    @ExcelProperty(index = 4)
    private String optionC;
    /**
     * 选项D
     */
    @ExcelProperty(index = 5)
    private String optionD;
    /**
     * 选项E
     */
    @ExcelProperty(index = 6)
    private String optionE;

    @ExcelProperty(index = 7)
    private String optionF;

    @ExcelProperty(index = 8)
    private String optionG;
    /**
     * 正确答案，多选如AB
     */
    @ExcelProperty(index = 9)
    private String answer;
    /**
     * 解析
     */
    @ExcelProperty(index = 10)
    private String analysis;

    /**
     * 适用人员类别（中文 ， 分隔）
     */
    @ExcelProperty(index = 11)
    private String suitablePersonTypes;


    @ApiModelProperty(value = "创建人id",hidden = true)
    private Long createBy;

    @ApiModelProperty(value = "创建人",hidden = true)
    private String createName;

    @ApiModelProperty(value = "更新人id",hidden = true)
    private Long updateBy;

    @ApiModelProperty(value = "更新人",hidden = true)
    private String updateName;

//    /**
//     * 适用工作类别（中文 ， 分隔）
//     */
//    @ExcelProperty(index = 10)
//    private String suitableJobTypes;

    public Integer getQuestionType() {
        if(this.questionTypeStr.equals("单选"))
            return 1;
        if(this.questionTypeStr.equals("多选"))
            return 2;
        if(this.questionTypeStr.equals("填空"))
            return 3;
        if(this.questionTypeStr.equals("判断"))
            return 4;
        return null;
    }

    public String getPersonTypeNames(){
        return this.suitablePersonTypes;
    }

    public String getSuitablePersonTypes() {
        if (this.suitablePersonTypes == null)
            return null;
        if(this.suitablePersonTypes.equals("主要负责人，职业卫生管理人员") ||
                this.suitablePersonTypes.equals("职业卫生管理人员，主要负责人"))
            return "200001,200002";
        if(this.suitablePersonTypes.equals("主要负责人"))
            return "200001";
        if(this.suitablePersonTypes.equals("职业卫生管理人员"))
            return "200002";
        return null;
    }
}
