package cn.smarthse.radiationTraining.modules.question.param;

import cn.smarthse.radiationTraining.core.framework.model.PageParam;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

/**
 * 试题查询参数对象
 *
 * @author wuxq
 * @date
 */
@EqualsAndHashCode(callSuper = false)
@Data
@NoArgsConstructor
public class QuestionSearchParam extends PageParam {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty("试题类型（1-单选题；2-多选题；3-填空题；4-判断题）")
    private Integer questionType;

    @ApiModelProperty("适用工作类别（单个）")
    private String jobCategory;

    @ApiModelProperty("人员类型（单个）")
    private String personType;

    @ApiModelProperty("行业（单个）")
    private String industryCode;

    @ApiModelProperty("适用危害因素（单个）")
    private String factorCode;

    @ApiModelProperty("适用课程（单个）")
    private String courseId;

    @ApiModelProperty("是否由本账号创建的试题(0-否；1-是)")
    private Integer isMyCreate;

    @ApiModelProperty(value = "uid",hidden = true)
    private Long uid;

    @ApiModelProperty(value = "是否为指定账号",hidden = true)
    private Boolean isSpecifiedUser = false;

    public QuestionSearchParam(String courseId) {
        this.courseId = courseId;
    }
}
