package cn.smarthse.radiationTraining.modules.question.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * 试题类型 枚举
 *
 * @author wuxq
 * @date 2022/3/24
 */
@AllArgsConstructor
@Getter
public enum QuestionTypeEnum {

    SINGLE_CHOICE(1, "单选题"),

    MULTIPLE_CHOICE(2, "多选题"),

    COMPLETION(3, "填空题"),

    JUDGE(4, "判断题");

    private Integer value;

    private String name;

    public static String getName(Integer index) {
        for (QuestionTypeEnum c : QuestionTypeEnum.values()) {
            if (c.getValue().equals(index)) {
                return c.name;
            }
        }
        return null;
    }
}
