package cn.smarthse.radiationTraining.modules.question.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.util.Date;


/**
 * <p>
 * 试题库
 * </p>
 *
 * @author wuxq
 * @since 2022-03-10
 */
@Accessors(chain = true)
@ApiModel(value = "Question对象", description = "试题")
@TableName("question")
public @Data class Question implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    private Long id;

    /**
     * 适用工作类别（id英文 , 分隔）
     */
    @ApiModelProperty(value = "适用工作类别（id英文 , 分隔）", hidden = true)
    private String suitableJobTypes;
    @ApiModelProperty(value = "适用危害因素（code英文 , 分隔）")
    private String suitableFactorNos;
    @ApiModelProperty(value = "适用人员类别（code英文 , 分隔）")
    private String suitablePersonTypes;
    @ApiModelProperty(value = "适用行业类别（code英文 , 分隔）")
    private String suitableIndustryCodes;
    @ApiModelProperty(value = "适用课程（code英文 , 分隔）")
    private String suitableCourseIds;

    // @ApiModelProperty(value = "适用工作类别名称", hidden = true)
    // private String suitableJobTypesStr;
    @ApiModelProperty(value = "适用危害因素名称（中文逗号分隔）")
    private String factorNoNames;
    @ApiModelProperty(value = "适用人员类别名称（中文逗号分隔）")
    private String personTypeNames;
    @ApiModelProperty(value = "适用行业类别名称（中文逗号分隔）")
    private String industryCodeNames;
    @ApiModelProperty(value = "适用课程名称（中文逗号分隔）")
    private String suitableCourseNames;

    @ApiModelProperty(value = "状态（0：已禁用；1：未入库(草稿状态)；2：已入库；）", required = true)
    private Integer status;

    @ApiModelProperty(value = "试题类别（1-单选题；2-多选题；3-填空题；4-判断题）", required = true)
    private Integer questionType;

    @ApiModelProperty(value = "题干", required = true)
    private String stem;

    @ApiModelProperty(value = "选项A", required = true)
    private String optionA;

    @ApiModelProperty(value = "选项B", required = true)
    private String optionB;

    @ApiModelProperty(value = "选项C", required = true)
    private String optionC;

    @ApiModelProperty(value = "选项D", required = true)
    private String optionD;

    @ApiModelProperty(value = "选项E", required = true)
    private String optionE;

    @ApiModelProperty(value = "选项F", required = true)
    private String optionF;

    @ApiModelProperty(value = "选项G", required = true)
    private String optionG;

    @ApiModelProperty(value = "正确答案（多选答案，如AB）", required = true)
    private String answer;

    @ApiModelProperty(value = "解析", required = true)
    private String analysis;

    @ApiModelProperty(hidden = true)
    private Long createBy;

    @ApiModelProperty(hidden = true)
    private Date createDate;

    @ApiModelProperty(hidden = true)
    private String createName;

    @ApiModelProperty(hidden = true)
    private Long updateBy;

    @ApiModelProperty(hidden = true)
    private Date updateDate;

    @ApiModelProperty(hidden = true)
    private String updateName;

    @ApiModelProperty(hidden = true)
    private Boolean isValid;


}
