package cn.smarthse.radiationTraining.modules.question.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;


/**
 * <p>
 * 试卷结构
 * </p>
 *
 * @author wuxq
 * @since 2022-03-10
 */
@TableName("paper_structure")
@Data
public class PaperStructure implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(value = "id", type = IdType.ASSIGN_ID)
    @ApiModelProperty(value = "id）")
    private Long id;
    /**
     * 试卷结构名称
     */
    @ApiModelProperty(value = "试卷结构名称")
    private String structName;
    /**
     * 组卷方式（默认1：自动；2：手动）
     */
    @ApiModelProperty(value = "组卷方式（默认1：自动；2：手动）")
    private Long way;
    /**
     * 单选题数
     */
    @ApiModelProperty(value = "单选题数")
    private Integer singleNum;
    /**
     * 多选题数
     */
    @ApiModelProperty(value = "多选题数")
    private Integer multipleNum;
    /**
     * 填空题数
     */
    @ApiModelProperty(value = "填空题数")
    private Integer completionNum;
    /**
     * 判断题数
     */
    @ApiModelProperty(value = "判断题数")
    private Integer judgeNum = 0;
    /**
     * 每个单选题分数
     */
    @ApiModelProperty(value = "每个单选题分数")
    private Integer singleScore;
    /**
     * 每个多选题分数
     */
    @ApiModelProperty(value = "每个多选题分数")
    private Integer multipleScore;
    /**
     * 每个填空题分数
     */
    @ApiModelProperty(value = "每个填空题分数")
    private Integer completionScore;
    /**
     * 每个判断题分数
     */
    @ApiModelProperty(value = "每个判断题分数")
    private Integer judgeScore;
    /**
     * 总分
     */
    @ApiModelProperty(value = "总分")
    private Integer totalScore;
    /**
     * 状态（1：禁用；2：启用）
     */
    @ApiModelProperty(value = "状态（0：禁用；1：启用）")
    private Integer status;
    /**
     * 创建者ID
     */
    @ApiModelProperty(hidden = true)
    private Long createBy;
    /**
     * 创建时间
     */
    @ApiModelProperty(hidden = true)
    private Date createDate;
    /**
     * 更新者ID
     */
    @ApiModelProperty(hidden = true)
    private Long updateBy;
    /**
     * 更新时间
     */
    @ApiModelProperty(hidden = true)
    private Date updateDate;
    /**
     * 是否有效（0：无效，1：有效）
     */
    @ApiModelProperty(hidden = true)
    private Boolean isValid;


}
