package cn.smarthse.radiationTraining.modules.wqxx.provider.answerExercise;


import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.answerExercise.SUserExamQuestionVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.answerExercise.SUserExamVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.answerExercise.SUserQuestionVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.answerExercise.ObtainExamQuestionParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.answerExercise.SubmitAnswerQuestionParam;

import java.util.List;

/**
 * IAnswerExerciseProviderService
 * 暴露接口
 * @author chuhy
 * @Date 2023/8/31
 */
public interface IAnswerExerciseProviderService {

    /**
     * 每周答题-列表
     * @param param
     * @return {@link List< SUserExamVo >}
     * @author chuhy
     * @date 2023/9/1 14:39
     */
    LayuiGridData<SUserExamVo> listWeekExam(ObtainExamQuestionParam param);

    /**
     * 每周答题-获取试题
     * @param param
     * @return {@link List<  SUserQuestionVo  >}
     * @author chuhy
     * @date 2023/9/1 14:39
     */
    SUserExamQuestionVo obtainWeekQuestions(ObtainExamQuestionParam param);

    /**
     * 每周答题-提交试题
     * @param param
     * @return {@link SUserExamVo}
     * @author chuhy
     * @date 2023/9/21 13:39
     */
    SUserExamVo submitWeekQuestions(SubmitAnswerQuestionParam param);

    /**
     * 专项答题-列表
     * @param param
     * @return {@link List< SUserExamVo >}
     * @author chuhy
     * @date 2023/9/1 14:39
     */
    LayuiGridData<SUserExamVo> listSpecialExam(ObtainExamQuestionParam param);

    /**
     * 专项答题-获取试题
     * @param param
     * @return {@link List<  SUserQuestionVo  >}
     * @author chuhy
     * @date 2023/9/1 14:39
     */
    SUserExamQuestionVo obtainSpecialQuestions(ObtainExamQuestionParam param);

    /**
     * 专项答题-提交试题
     * @param param
     * @return {@link SUserExamVo}
     * @author chuhy
     * @date 2023/9/21 13:39
     */
    SUserExamVo submitSpecialQuestions(SubmitAnswerQuestionParam param);


    /**
     * 挑战答题-获取试题
     * @param param
     * @return {@link List< SUserQuestionVo>}
     * @author chuhy
     * @date 2023/9/22 10:02
     */
    SUserExamQuestionVo obtainChallengeQuestions(ObtainExamQuestionParam param);

    /**
     * 挑战答题-提交试题
     * @param param
     * @return {@link SUserExamVo}
     * @author chuhy
     * @date 2023/9/21 13:39
     */
    SUserExamVo submitChallengeQuestions(SubmitAnswerQuestionParam param);


    /**
     * 定时任务 - 处理没有提交试卷的每周答题
     * @author chuhy
     * @date 2023/11/17 14:55
     */
    void handleUnexaminedPaper(String examId);
}
