package cn.smarthse.radiationTraining.modules.wqxx.provider;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.integraLog.StaffStudyArchivesVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.integraLog.StaffStudyIntegralVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.integraLog.StaffTodayIntegralVo;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.integraLog.UnitStudyArchivesVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.integraLog.StudyArchivesSearchParam;

import java.util.List;

/**
 * 用户积分
 */
public interface ISUserIntegralProviderService {

    //------------------------------------------------------监管端----------------------------------------------------

    /**
     * 方法描述:  劳动者用户学习记录
     *
     * @param param 查询参数
     * @return LayuiGridData<StaffStudyArchivesVo>
     * @author wuxq
     * @date 2023/8/31
     */
    LayuiGridData<StaffStudyArchivesVo> getStaffStudyArchivesPageData(StudyArchivesSearchParam param);

    /**
     * 方法描述:  查询用户信息
     *
     * @param userId 用户id
     * @return StaffStudyIntegralVo
     * @author wuxq
     * @date 2023/9/25
     */
    StaffStudyIntegralVo getStaffStudyIntegralVo(StudyArchivesSearchParam param);

    /**
     * 方法描述:  根据用户id查询劳动者学习记录
     *
     * @param param 用户id
     * @return LayuiGridData<StaffStudyArchivesVo>
     * @author wuxq
     * @date 2023/9/22
     */
    LayuiGridData<StaffStudyArchivesVo> getStaffStudyDetailsPageData(StudyArchivesSearchParam param);

    /**
     * 方法描述:  用人单位用户学习记录
     *
     * @param param 查询参数
     * @return LayuiGridData<StaffStudyArchivesVo>
     * @author wuxq
     * @date 2023/8/31
     */
    LayuiGridData<UnitStudyArchivesVo> getUnitStudyArchivesPageData(StudyArchivesSearchParam param);

    /**
     * 方法描述:  根据cid查询用人单位学习记录
     *
     * @param param 用人单位id
     * @return LayuiGridData<UnitStudyArchivesVo>
     * @author wuxq
     * @date 2023/9/21
     */
    LayuiGridData<UnitStudyArchivesVo> getUnitStudyDetailsPageData(StudyArchivesSearchParam param);

    //------------------------------------------------------移动端----------------------------------------------------
    /**
     * 方法描述:  本单位学习标兵排行
     *
     * @param   param 查询参数
     * @return  List<StaffStudyArchivesVo>
     * @author  wuxq
     * @date    2023/9/26
     */
    List<StaffStudyArchivesVo> getStaffIntegralRankList(StudyArchivesSearchParam param);

    /**
     * 方法描述:  个人积分统计
     *
     * @param   userId 用户id
     * @return  StaffStudyIntegralVo
     * @author  wuxq
     * @date    2023/9/26
     */
    StaffStudyIntegralVo getStaffIntegral(StudyArchivesSearchParam param);

    /**
     * 方法描述:  今日个人积分
     *
     * @param   param 用户id、cid
     * @return  StaffTodayIntegralVo
     * @author  wuxq
     * @since    2023/10/12
     */
    StaffTodayIntegralVo getStaffTodayIntegral(StudyArchivesSearchParam param);

    /**
     * 方法描述:  根据身份证号查询用户id
     *
     * @param   idCard 身份证号
     * @return  Long
     * @author  wuxq
     * @date    2023/12/7
     */
    Long getSysUserIdByIdCard(String idCard);
}
