package cn.smarthse.radiationTraining.modules.wqxx.provider;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.question.SQuestionVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.ImportSQuestionData;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.SQuestionBatchAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.SQuestionEditParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SQuestion.SQuestionListAdminParam;

import java.util.List;

/**
* @author chenliang
* @description 题库dubbo接口
* @createDate 2023-08-28 10:34:05
*/
public interface ISQuestionProviderService{

    /**
     * @description: 添加试题
     * @author: chenliang
     * @date: 2023/9/12 13:09
     * @param param
     * @return:
     */
    void addForAdmin(SQuestionEditParam param);

    /**
     * @description: 编辑试题
     * @author: chenliang
     * @date: 2023/9/12 13:20
     * @param param
     * @return:
     */
    void editForAdmin(SQuestionEditParam param);

    /**
     * @description: 批量删除
     * @author: chenliang
     * @date: 2023/9/12 13:25
     * @param param
     * @return:
     */
    void delBatchForAdmin(SQuestionBatchAdminParam param);

    /**
     * @description: 批量启用禁用
     * @author: chenliang
     * @date: 2023/9/12 13:25
     * @param param
     * @return:
     */
    void upOrDownBatchForAdmin(SQuestionBatchAdminParam param);

    /**
     * @description: 管理列表
     * @author: chenliang
     * @date: 2023/9/12 13:34
     * @param param
     * @return:
     */
    LayuiGridData<SQuestionVo> listForAdmin(SQuestionListAdminParam param);

    /**
     * @description: 获取详情
     * @author: chenliang
     * @date: 2023/9/12 14:05
     * @param id
     * @return: {@link SQuestionVo}
     */
    SQuestionVo getDetailForAdmin(Long id);

    /**
     * @description: 导入题库
     * @author: chenliang
     * @date: 2023/9/14 15:33
     * @param list
     * @return: {@link List< String>}
     */
    List<String> importQuestion(List<ImportSQuestionData> list);
}
