package cn.smarthse.radiationTraining.modules.wqxx.provider;

import cn.smarthse.radiationTraining.core.framework.model.LayuiGridData;
import cn.smarthse.radiationTraining.modules.wqxx.model.vo.exam.ExamVo;
import cn.smarthse.radiationTraining.modules.wqxx.param.SExam.SExamBatchAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SExam.SExamEditAdminParam;
import cn.smarthse.radiationTraining.modules.wqxx.param.SExam.SExamListAdminParam;

/**
* @author chenliang
* @description 答题dubbo接口
* @createDate 2023-08-28 10:34:05
*/
public interface ISExamProviderService {

    /**
     * @description: 添加答题
     * @author: chenliang
     * @date: 2023/9/11 14:26
     * @param param
     */
    void addForAdmin(SExamEditAdminParam param);

    /**
     * @description: 每周答题生成
     * @author: chenliang
     * @date: 2023/9/22 13:08
     * @param
     * @return:
     */
    void randomGeneration();

    /**
     * @description: 编辑答题
     * @author: chenliang
     * @date: 2023/9/11 14:51
     * @param param
     * @return:
     */
    void editForAdmin(SExamEditAdminParam param);

    /**
     * @description: 列表查询
     * @author: chenliang
     * @date: 2023/9/11 16:28
     * @param param
     * @return: {@link LayuiGridData< ExamVo>}
     */
    LayuiGridData<ExamVo> listForAdmin(SExamListAdminParam param);

    /**
     * @description: 查看详情
     * @author: chenliang
     * @date: 2023/9/11 16:41
     * @param id
     * @return: {@link ExamVo}
     */
    ExamVo getDetailForAdmin(Long id);

    /**
     * @description: 删除
     * @author: chenliang
     * @date: 2023/9/11 16:28
     * @param param
     * @return:
     */
    void delBatchForAdmin(SExamBatchAdminParam param);

    /**
     * @description: 上下架
     * @author: chenliang
     * @date: 2023/9/11 16:32
     * @param param
     * @return:
     */
    void upOrDownBatchForAdmin(SExamBatchAdminParam param);
}
