package cn.smarthse.radiationTraining.modules.wqxx.model.vo.question;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 卫企学习：试题库-选择题
* @TableName s_question
*/
@Data
public class SQuestionVo implements Serializable {
    
    //@ApiModelProperty("")
    private Long id;

    //@ApiModelProperty("试题类别（1-单选题；2-多选题；3-填空题；4-判断题）")
    private Integer type;

    //@ApiModelProperty("题干")
    private String stem;

    //@ApiModelProperty("状态（0：已禁用(不用的试题,过时的试题)；1：未入库(草稿状态)；2：已入库；）")
    private Integer state;

    //@ApiModelProperty("选项A(对)")
    private String optionA;

    //@ApiModelProperty("选项B(错)")
    private String optionB;

    //@ApiModelProperty("选项C")
    private String optionC;

    //@ApiModelProperty("选项D")
    private String optionD;
    
    //@ApiModelProperty("选项E")
    private String optionE;

    //@ApiModelProperty("选项F")
    private String optionF;

    //@ApiModelProperty("选项G")
    private String optionG;

    //@ApiModelProperty("正确答案（多选：AB）")
    private String answer;

    //@ApiModelProperty("解析")
    private String analysis;


    //@ApiModelProperty("最近维护人")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String recentMaintainer;

    //@ApiModelProperty("最近维护时间")
    private Date updateDate;

    //@ApiModelProperty("创建人")
    private Long createBy;

}