package cn.smarthse.radiationTraining.modules.wqxx.model.vo.integraLog;

import cn.smarthse.framework.encrypt.annotation.EncryptField;
import cn.smarthse.framework.encrypt.enumd.DataProcessingMethodsType;
import cn.smarthse.framework.sensitive.annotation.Desensitization;
import cn.smarthse.framework.sensitive.enumd.DesensitizationType;
import lombok.Data;

import java.io.Serializable;


/**
 * <p>
 * 劳动者今日积分 vo
 * </p>
 *
 * @author wuxq
 * @since 2023-8-30
 */
@Data
public class StaffTodayIntegralVo implements Serializable {

    private static final long serialVersionUID = 1L;

    //@ApiModelProperty("id")
    private Long userId;

    //@ApiModelProperty(value = "cid")
    private Long cid;

    //@ApiModelProperty(value = "姓名")
    @Desensitization(type = DesensitizationType.NAME)
    @EncryptField(dataProcessingMethodsType = DataProcessingMethodsType.ACCURATE)
    private String name;

    //@ApiModelProperty(value = "今日总积分")
    private int integralTotal;

    //@ApiModelProperty(value = "账号登录")
    private int integral1;

    //@ApiModelProperty(value = "视频学习")
    private int integral2;

    //@ApiModelProperty(value = "文章学习")
    private int integral3;

    //@ApiModelProperty(value = "每周答题")
    private int integral4;

    //@ApiModelProperty(value = "专项答题")
    private int integral5;

    //@ApiModelProperty(value = "挑战答题")
    private int integral6;
}
